/*
 * Decompiled with CFR 0.152.
 */
package co.elasticsearch.enterprisesearch.client.model.response.documents;

import co.elasticsearch.enterprisesearch.client.model.response.ErrorableResponse;
import co.elasticsearch.enterprisesearch.client.model.response.documents.IndexResult;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class IndexResponse
implements Iterable<IndexResult>,
ErrorableResponse {
    @JsonValue
    private List<IndexResult> documents = new ArrayList<IndexResult>();

    @Override
    @NotNull
    public Iterator<IndexResult> iterator() {
        return this.documents.iterator();
    }

    @Override
    public Spliterator<IndexResult> spliterator() {
        return this.documents.spliterator();
    }

    @Override
    public void forEach(Consumer<? super IndexResult> action) {
        this.documents.forEach(action);
    }

    @Override
    public boolean isError() {
        return this.documents.stream().anyMatch(r -> !r.getErrors().isEmpty());
    }

    public List<IndexResult> getErrors() {
        return this.documents.stream().filter(r -> !r.getErrors().isEmpty()).collect(Collectors.toList());
    }

    public Set<String> getIds() {
        return this.documents.stream().map(IndexResult::getId).collect(Collectors.toSet());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IndexResponse)) {
            return false;
        }
        IndexResponse response = (IndexResponse)o;
        return Objects.equals(this.documents, response.documents);
    }

    public int hashCode() {
        return Objects.hash(this.documents);
    }

    public List<IndexResult> getDocuments() {
        return this.documents;
    }

    public IndexResponse setDocuments(List<IndexResult> documents) {
        this.documents = documents;
        return this;
    }

    public String toString() {
        return "IndexResponse(documents=" + this.getDocuments() + ")";
    }
}

