/*
 * Decompiled with CFR 0.152.
 */
package co.elasticsearch.enterprisesearch.client.model.response.engines;

import co.elasticsearch.enterprisesearch.client.model.response.ErrorableResponse;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class EngineResponse
implements ErrorableResponse {
    private String name;
    private String type;
    private String language;
    @JsonProperty(value="document_count")
    private Long documentCount;
    @JsonProperty(value="index_create_settings_override")
    private Map<String, Object> indexCreateSettingsOverride = new LinkedHashMap<String, Object>();
    private List<String> errors = new ArrayList<String>();

    @JsonIgnore
    public Object getIndexSettingOverride(String key) {
        return this.indexCreateSettingsOverride.get(key);
    }

    @JsonIgnore
    public Set<String> getIndexSettingOverrideNames() {
        return this.indexCreateSettingsOverride.keySet();
    }

    @Override
    @JsonIgnore
    public boolean isError() {
        return !this.errors.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EngineResponse)) {
            return false;
        }
        EngineResponse that = (EngineResponse)o;
        return this.name.equals(that.name) && this.type.equals(that.type) && Objects.equals(this.language, that.language) && Objects.equals(this.documentCount, that.documentCount) && Objects.equals(this.indexCreateSettingsOverride, that.indexCreateSettingsOverride) && Objects.equals(this.errors, that.errors);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.type, this.language, this.documentCount, this.indexCreateSettingsOverride, this.errors);
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public String getLanguage() {
        return this.language;
    }

    public Long getDocumentCount() {
        return this.documentCount;
    }

    public List<String> getErrors() {
        return this.errors;
    }

    public EngineResponse setName(String name) {
        this.name = name;
        return this;
    }

    public EngineResponse setType(String type) {
        this.type = type;
        return this;
    }

    public EngineResponse setLanguage(String language) {
        this.language = language;
        return this;
    }

    @JsonProperty(value="document_count")
    public EngineResponse setDocumentCount(Long documentCount) {
        this.documentCount = documentCount;
        return this;
    }

    public EngineResponse setErrors(List<String> errors) {
        this.errors = errors;
        return this;
    }

    public String toString() {
        return "EngineResponse(name=" + this.getName() + ", type=" + this.getType() + ", language=" + this.getLanguage() + ", documentCount=" + this.getDocumentCount() + ", indexCreateSettingsOverride=" + this.getIndexCreateSettingsOverride() + ", errors=" + this.getErrors() + ")";
    }

    Map<String, Object> getIndexCreateSettingsOverride() {
        return this.indexCreateSettingsOverride;
    }

    @JsonProperty(value="index_create_settings_override")
    EngineResponse setIndexCreateSettingsOverride(Map<String, Object> indexCreateSettingsOverride) {
        this.indexCreateSettingsOverride = indexCreateSettingsOverride;
        return this;
    }
}

