/*
 * Decompiled with CFR 0.152.
 */
package co.elasticsearch.enterprisesearch.client.model.response.schemas;

import co.elasticsearch.enterprisesearch.client.model.response.ErrorableResponse;
import co.elasticsearch.enterprisesearch.client.model.response.schemas.FieldType;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class Schema
implements ErrorableResponse {
    @JsonAnyGetter
    @JsonAnySetter
    private final Map<String, FieldType> fields = new LinkedHashMap<String, FieldType>();
    private List<String> errors = new ArrayList<String>();

    @JsonIgnore
    public FieldType getField(String fieldName) {
        return this.fields.get(fieldName);
    }

    @JsonIgnore
    public Schema setField(String fieldName, FieldType fieldType) {
        this.fields.put(fieldName, fieldType);
        return this;
    }

    @JsonIgnore
    public Set<String> getFieldNames() {
        return this.fields.keySet();
    }

    @Override
    @JsonIgnore
    public boolean isError() {
        return !this.errors.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Schema)) {
            return false;
        }
        Schema schema = (Schema)o;
        return Objects.equals(this.fields, schema.fields) && Objects.equals(this.errors, schema.errors);
    }

    public int hashCode() {
        return Objects.hash(this.fields, this.errors);
    }

    public String toString() {
        return "Schema(fields=" + this.fields + ", errors=" + this.getErrors() + ")";
    }

    public List<String> getErrors() {
        return this.errors;
    }

    public void setErrors(List<String> errors) {
        this.errors = errors;
    }
}

