/*
 * Decompiled with CFR 0.152.
 */
package co.elasticsearch.enterprisesearch.client;

public class ClientAuthentication {
    private final String username;
    private final String password;
    private final String token;

    public static ClientAuthentication withBearerAuth(String token) {
        if (token == null || token.isBlank()) {
            throw new IllegalArgumentException("Token cannot be empty");
        }
        return new ClientAuthentication(token);
    }

    public static ClientAuthentication withBasicAuth(String username, String password) {
        if (username == null || password == null || username.isBlank() || password.isBlank()) {
            throw new IllegalArgumentException("Username and/or Password cannot be empty");
        }
        return new ClientAuthentication(username, password);
    }

    boolean isTokenAuthentication() {
        return this.token != null;
    }

    private ClientAuthentication(String username, String password) {
        this.username = username;
        this.password = password;
        this.token = null;
    }

    private ClientAuthentication(String token) {
        this.username = null;
        this.password = null;
        this.token = token;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getToken() {
        return this.token;
    }
}

