/*
 * Decompiled with CFR 0.152.
 */
package co.elasticsearch.enterprisesearch.client;

import co.elasticsearch.enterprisesearch.client.ClientUtils;
import co.elasticsearch.enterprisesearch.client.DocumentsApi;
import co.elasticsearch.enterprisesearch.client.ElasticClientException;
import co.elasticsearch.enterprisesearch.client.model.AppSearchErrorResponseException;
import co.elasticsearch.enterprisesearch.client.model.request.Page;
import co.elasticsearch.enterprisesearch.client.model.response.documents.DeleteResponse;
import co.elasticsearch.enterprisesearch.client.model.response.documents.IndexResponse;
import co.elasticsearch.enterprisesearch.client.model.response.documents.IndexResult;
import co.elasticsearch.enterprisesearch.client.model.response.documents.ListResponse;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.TypeFactory;
import dev.failsafe.Failsafe;
import dev.failsafe.Policy;
import dev.failsafe.RetryPolicy;
import dev.failsafe.RetryPolicyBuilder;
import jakarta.validation.constraints.NotNull;
import java.io.IOException;
import java.time.Duration;
import java.util.List;
import java.util.Objects;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DocumentsApiImpl<T>
implements DocumentsApi<T> {
    private static final Logger log = LoggerFactory.getLogger(DocumentsApiImpl.class);
    private final ObjectMapper objectMapper;
    private final String baseUrl;
    private final OkHttpClient client;
    private final Class<T> resultType;
    private static final String DOCUMENTS_PATH = "/api/as/v1/engines/{engineName}/documents";
    private RetryPolicy<Object> retryPolicy = ((RetryPolicyBuilder)((RetryPolicyBuilder)RetryPolicy.builder().handle(AppSearchErrorResponseException.class)).handle(IOException.class)).withBackoff(Duration.ofSeconds(2L), Duration.ofSeconds(128L)).build();

    public DocumentsApi<T> setBackoff(@NotNull Duration delay, @NotNull Duration maxDelay, double delayFactor) {
        this.retryPolicy = ((RetryPolicyBuilder)((RetryPolicyBuilder)RetryPolicy.builder().handle(AppSearchErrorResponseException.class)).handle(IOException.class)).withBackoff(delay, maxDelay, delayFactor).build();
        return this;
    }

    public DocumentsApi<T> disableRetries() {
        this.retryPolicy = RetryPolicy.builder().withMaxRetries(0).build();
        return this;
    }

    @Override
    public IndexResponse index(String engineName, List<T> documents) {
        HttpUrl url = Objects.requireNonNull(HttpUrl.parse((String)(this.baseUrl + DOCUMENTS_PATH))).newBuilder().setPathSegment(4, engineName).build();
        log.debug("Indexing {} documents:{}", (Object)documents.size(), (Object)url);
        Request okRequest = new Request.Builder().url(url).post(ClientUtils.marshalPayload(this.objectMapper, documents)).build();
        JavaType listType = TypeFactory.defaultInstance().constructParametricType(List.class, new Class[]{IndexResult.class});
        List results = (List)Failsafe.with(this.retryPolicy, (Policy[])new RetryPolicy[0]).get(() -> (List)ClientUtils.marshalResponse(this.client, okRequest, this.objectMapper, listType));
        return new IndexResponse().setDocuments(results);
    }

    @Override
    public List<T> getDocuments(String engineName, List<String> ids) {
        HttpUrl.Builder urlBuilder = Objects.requireNonNull(HttpUrl.parse((String)(this.baseUrl + DOCUMENTS_PATH))).newBuilder();
        urlBuilder.setPathSegment(4, engineName);
        if (ids != null && !ids.isEmpty()) {
            try {
                urlBuilder.addQueryParameter(engineName, this.objectMapper.writeValueAsString(ids));
            }
            catch (IOException e) {
                throw new ElasticClientException(e);
            }
        }
        HttpUrl url = urlBuilder.build();
        log.debug("Getting documents:{}", (Object)url);
        Request okRequest = new Request.Builder().url(url).get().build();
        JavaType listType = TypeFactory.defaultInstance().constructParametricType(List.class, new Class[]{this.resultType});
        return (List)Failsafe.with(this.retryPolicy, (Policy[])new RetryPolicy[0]).get(() -> (List)ClientUtils.marshalResponse(this.client, okRequest, this.objectMapper, listType));
    }

    @Override
    public DeleteResponse delete(String engineName, List<String> ids) {
        HttpUrl url = Objects.requireNonNull(HttpUrl.parse((String)(this.baseUrl + DOCUMENTS_PATH))).newBuilder().setPathSegment(4, engineName).build();
        log.debug("Indexing documents:{}", (Object)url);
        Request okRequest = new Request.Builder().url(url).delete(ClientUtils.marshalPayload(this.objectMapper, ids)).build();
        return (DeleteResponse)Failsafe.with(this.retryPolicy, (Policy[])new RetryPolicy[0]).get(() -> ClientUtils.marshalResponse(this.client, okRequest, this.objectMapper, DeleteResponse.class));
    }

    @Override
    public ListResponse<T> listDocuments(String engineName, Page page) {
        HttpUrl.Builder urlBuilder = Objects.requireNonNull(HttpUrl.parse((String)(this.baseUrl + DOCUMENTS_PATH))).newBuilder();
        urlBuilder.setPathSegment(4, engineName);
        ClientUtils.addPagination(urlBuilder, page);
        HttpUrl url = urlBuilder.build();
        Request okRequest = new Request.Builder().url(url).get().build();
        JavaType listType = TypeFactory.defaultInstance().constructParametricType(List.class, new Class[]{this.resultType});
        return (ListResponse)Failsafe.with(this.retryPolicy, (Policy[])new RetryPolicy[0]).get(() -> (ListResponse)ClientUtils.marshalResponse(this.client, okRequest, this.objectMapper, listType));
    }

    public DocumentsApiImpl(ObjectMapper objectMapper, String baseUrl, OkHttpClient client, Class<T> resultType) {
        this.objectMapper = objectMapper;
        this.baseUrl = baseUrl;
        this.client = client;
        this.resultType = resultType;
    }
}

