/*
 * Decompiled with CFR 0.152.
 */
package co.elasticsearch.enterprisesearch.client;

import co.elasticsearch.enterprisesearch.client.ClientUtils;
import co.elasticsearch.enterprisesearch.client.EnginesApi;
import co.elasticsearch.enterprisesearch.client.model.request.Page;
import co.elasticsearch.enterprisesearch.client.model.request.engines.CreateEngine;
import co.elasticsearch.enterprisesearch.client.model.response.engines.EngineResponse;
import co.elasticsearch.enterprisesearch.client.model.response.engines.EnginesResponse;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Objects;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class EnginesApiImpl
implements EnginesApi {
    private static final Logger log = LoggerFactory.getLogger(EnginesApiImpl.class);
    private final ObjectMapper objectMapper;
    private final String baseUrl;
    private final OkHttpClient client;
    private static final String ENGINES_PATH = "/api/as/v1/engines";

    @Override
    public EngineResponse getEngineByName(String engineName) {
        HttpUrl url = Objects.requireNonNull(HttpUrl.parse((String)(this.baseUrl + "/api/as/v1/engines/{engineName}"))).newBuilder().setPathSegment(4, engineName).build();
        Request okRequest = new Request.Builder().url(url).get().build();
        return ClientUtils.marshalResponse(this.client, okRequest, this.objectMapper, EngineResponse.class);
    }

    @Override
    public EnginesResponse listEngines(Page page) {
        HttpUrl.Builder urlBuilder = Objects.requireNonNull(HttpUrl.parse((String)(this.baseUrl + ENGINES_PATH))).newBuilder();
        if (page != null) {
            if (page.getCurrent() != null) {
                urlBuilder.addQueryParameter("page[current]", String.valueOf(page.getCurrent()));
            }
            if (page.getSize() != null) {
                urlBuilder.addQueryParameter("page[size]", String.valueOf(page.getSize()));
            }
        }
        Request okRequest = new Request.Builder().url(urlBuilder.build()).get().build();
        return ClientUtils.marshalResponse(this.client, okRequest, this.objectMapper, EnginesResponse.class);
    }

    @Override
    public EngineResponse createEngine(CreateEngine engine) {
        Request okRequest = new Request.Builder().url(HttpUrl.parse((String)(this.baseUrl + ENGINES_PATH))).post(ClientUtils.marshalPayload(this.objectMapper, engine)).build();
        return ClientUtils.marshalResponse(this.client, okRequest, this.objectMapper, EngineResponse.class);
    }

    @Override
    public boolean deleteEngine(String engineName) {
        HttpUrl url = Objects.requireNonNull(HttpUrl.parse((String)(this.baseUrl + "/api/as/v1/engines/{engineName}"))).newBuilder().setPathSegment(4, engineName).build();
        log.debug("Getting Engine {}", (Object)url);
        Request okRequest = new Request.Builder().url(url).delete().build();
        return ClientUtils.marshalResponse((OkHttpClient)this.client, (Request)okRequest, (ObjectMapper)this.objectMapper, DeleteResponse.class).deleted;
    }

    public EnginesApiImpl(ObjectMapper objectMapper, String baseUrl, OkHttpClient client) {
        this.objectMapper = objectMapper;
        this.baseUrl = baseUrl;
        this.client = client;
    }

    private static class DeleteResponse {
        boolean deleted;

        private DeleteResponse() {
        }
    }
}

