/*
 * Decompiled with CFR 0.152.
 */
package co.elasticsearch.enterprisesearch.client;

import co.elasticsearch.enterprisesearch.client.ClientUtils;
import co.elasticsearch.enterprisesearch.client.SchemaApi;
import co.elasticsearch.enterprisesearch.client.model.response.schemas.Schema;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Objects;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SchemaApiImpl
implements SchemaApi {
    private static final Logger log = LoggerFactory.getLogger(SchemaApiImpl.class);
    private final ObjectMapper objectMapper;
    private final String baseUrl;
    private final OkHttpClient client;
    private static final String SCHEMA_PATH = "/api/as/v1/engines/{engineName}/schema";

    @Override
    public Schema getSchema(String engineName) {
        HttpUrl url = Objects.requireNonNull(HttpUrl.parse((String)(this.baseUrl + SCHEMA_PATH))).newBuilder().setPathSegment(4, engineName).build();
        Request okRequest = new Request.Builder().url(url).get().build();
        return ClientUtils.marshalResponse(this.client, okRequest, this.objectMapper, Schema.class);
    }

    @Override
    public Schema updateSchema(String engineName, Schema schema) {
        HttpUrl url = Objects.requireNonNull(HttpUrl.parse((String)(this.baseUrl + SCHEMA_PATH))).newBuilder().setPathSegment(4, engineName).build();
        log.debug("Update schema {} fields:{}", (Object)schema.getFieldNames().size(), (Object)url);
        Request okRequest = new Request.Builder().url(url).post(ClientUtils.marshalPayload(this.objectMapper, schema)).build();
        return ClientUtils.marshalResponse(this.client, okRequest, this.objectMapper, Schema.class);
    }

    public SchemaApiImpl(ObjectMapper objectMapper, String baseUrl, OkHttpClient client) {
        this.objectMapper = objectMapper;
        this.baseUrl = baseUrl;
        this.client = client;
    }
}

