/*
 * Decompiled with CFR 0.152.
 */
package co.elasticsearch.enterprisesearch.client;

import co.elasticsearch.enterprisesearch.client.ClientUtils;
import co.elasticsearch.enterprisesearch.client.SourceEnginesApi;
import co.elasticsearch.enterprisesearch.client.model.response.sourceengines.SourceEnginesResponse;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import java.util.Objects;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SourceEnginesApiImpl
implements SourceEnginesApi {
    private static final Logger log = LoggerFactory.getLogger(SourceEnginesApiImpl.class);
    private final ObjectMapper objectMapper;
    private final String baseUrl;
    private final OkHttpClient client;
    private static final String SOURCE_ENGINES_PATH = "/api/as/v1/engines/{engineName}/source_engines";

    @Override
    public SourceEnginesResponse addSourceEngine(String metaEngineName, List<String> sourceEngineNames) {
        HttpUrl url = Objects.requireNonNull(HttpUrl.parse((String)(this.baseUrl + SOURCE_ENGINES_PATH))).newBuilder().setPathSegment(4, metaEngineName).build();
        log.debug("Adding meta engines {} , source engines:{}", (Object)url, sourceEngineNames);
        Request okRequest = new Request.Builder().url(url).post(ClientUtils.marshalPayload(this.objectMapper, sourceEngineNames)).build();
        return ClientUtils.marshalResponse(this.client, okRequest, this.objectMapper, SourceEnginesResponse.class);
    }

    @Override
    public SourceEnginesResponse removeSourceEngine(String metaEngineName, List<String> sourceEngineNames) {
        HttpUrl url = Objects.requireNonNull(HttpUrl.parse((String)(this.baseUrl + SOURCE_ENGINES_PATH))).newBuilder().setPathSegment(4, metaEngineName).build();
        log.debug("Removing meta engines {} , source engines:{}", (Object)url, sourceEngineNames);
        Request okRequest = new Request.Builder().url(url).delete(ClientUtils.marshalPayload(this.objectMapper, sourceEngineNames)).build();
        return ClientUtils.marshalResponse(this.client, okRequest, this.objectMapper, SourceEnginesResponse.class);
    }

    public SourceEnginesApiImpl(ObjectMapper objectMapper, String baseUrl, OkHttpClient client) {
        this.objectMapper = objectMapper;
        this.baseUrl = baseUrl;
        this.client = client;
    }
}

