/*
 * Decompiled with CFR 0.152.
 */
package co.elasticsearch.enterprisesearch.client.model.request.search;

import co.elasticsearch.enterprisesearch.client.model.request.search.ResultFieldRendered;
import co.elasticsearch.enterprisesearch.client.model.request.search.ResultFieldSerializer;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.Objects;

@JsonSerialize(using=ResultFieldSerializer.class)
public class ResultField {
    @JsonIgnore
    private String name;
    private ResultFieldRendered raw;
    private ResultFieldRendered snippet;

    public ResultField() {
    }

    public ResultField(String name) {
        this.name = name;
    }

    public ResultField withRaw() {
        this.raw = new ResultFieldRendered();
        return this;
    }

    public ResultField withRaw(int size) {
        this.raw = new ResultFieldRendered().setSize(size);
        return this;
    }

    public ResultField withoutRaw() {
        this.raw = null;
        return this;
    }

    public ResultField withSnippet() {
        this.snippet = new ResultFieldRendered();
        return this;
    }

    public ResultField withSnippet(int size) {
        this.snippet = new ResultFieldRendered().setSize(size);
        return this;
    }

    public ResultField withSnippet(int size, Boolean fallback) {
        this.snippet = new ResultFieldRendered().setSize(size).setFallback(fallback);
        return this;
    }

    public ResultField withSnippet(Boolean fallback) {
        this.snippet = new ResultFieldRendered().setFallback(fallback);
        return this;
    }

    public ResultField withoutSnippet() {
        this.snippet = null;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ResultField)) {
            return false;
        }
        ResultField that = (ResultField)o;
        return Objects.equals(this.raw, that.raw) && Objects.equals(this.snippet, that.snippet);
    }

    public int hashCode() {
        return Objects.hash(this.raw, this.snippet);
    }

    public String getName() {
        return this.name;
    }

    @JsonIgnore
    public ResultField setName(String name) {
        this.name = name;
        return this;
    }

    public ResultField setRaw(ResultFieldRendered raw) {
        this.raw = raw;
        return this;
    }

    public ResultField setSnippet(ResultFieldRendered snippet) {
        this.snippet = snippet;
        return this;
    }

    ResultFieldRendered getRaw() {
        return this.raw;
    }

    ResultFieldRendered getSnippet() {
        return this.snippet;
    }
}

