/*
 * Decompiled with CFR 0.152.
 */
package co.elasticsearch.enterprisesearch.client.model.request.search.boost;

import co.elasticsearch.enterprisesearch.client.model.request.search.boost.Boost;
import co.elasticsearch.enterprisesearch.client.model.request.search.filter.DateValueFilter;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.math.BigDecimal;
import java.time.OffsetDateTime;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder(value={"type", "function", "center", "factor"})
public class RecencyBoost
implements Boost {
    private String name;
    private Boost.Function function;
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss[.SS]XXX")
    private OffsetDateTime center;
    @JsonIgnore
    private boolean useNow = false;
    private BigDecimal factor;

    @Override
    public Boost.BoostType getType() {
        return Boost.BoostType.PROXIMITY;
    }

    @JsonGetter
    public String getCenter() {
        if (this.useNow) {
            return "now";
        }
        if (this.center != null) {
            return DateValueFilter.RFC_3339.format(this.center);
        }
        return null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Boost.Function getFunction() {
        return this.function;
    }

    public boolean isUseNow() {
        return this.useNow;
    }

    @Override
    public BigDecimal getFactor() {
        return this.factor;
    }

    @Override
    public RecencyBoost setName(String name) {
        this.name = name;
        return this;
    }

    public RecencyBoost setFunction(Boost.Function function) {
        this.function = function;
        return this;
    }

    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss[.SS]XXX")
    public RecencyBoost setCenter(OffsetDateTime center) {
        this.center = center;
        return this;
    }

    @JsonIgnore
    public RecencyBoost setUseNow(boolean useNow) {
        this.useNow = useNow;
        return this;
    }

    @Override
    public RecencyBoost setFactor(BigDecimal factor) {
        this.factor = factor;
        return this;
    }
}

