/*
 * Decompiled with CFR 0.152.
 */
package co.elasticsearch.enterprisesearch.client.model.request.search.filter;

import co.elasticsearch.enterprisesearch.client.model.request.search.filter.Filter;
import co.elasticsearch.enterprisesearch.client.model.request.search.range.NumberRange;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.math.BigDecimal;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class NumberRangeFilter
implements Filter {
    private final String name;
    private BigDecimal from;
    private BigDecimal to;

    public NumberRangeFilter(String name, BigDecimal from, BigDecimal to) {
        this(name);
        this.from = from;
        this.to = to;
    }

    public NumberRangeFilter(String name, Integer from, Integer to) {
        this(name);
        if (from != null) {
            this.from = new BigDecimal(from);
        }
        if (to != null) {
            this.to = new BigDecimal(to);
        }
    }

    public NumberRangeFilter(String name, Long from, Long to) {
        this(name);
        if (from != null) {
            this.from = new BigDecimal(from);
        }
        if (to != null) {
            this.to = new BigDecimal(to);
        }
    }

    public NumberRangeFilter(String name, Float from, Float to) {
        this(name);
        if (from != null) {
            this.from = BigDecimal.valueOf(from.floatValue());
        }
        if (to != null) {
            this.to = BigDecimal.valueOf(to.floatValue());
        }
    }

    public NumberRangeFilter(String name, Double from, Double to) {
        this(name);
        if (from != null) {
            this.from = BigDecimal.valueOf(from);
        }
        if (to != null) {
            this.to = BigDecimal.valueOf(to);
        }
    }

    public NumberRangeFilter setRange(NumberRange range) {
        this.from = range == null ? null : range.getFrom();
        this.to = range == null ? null : range.getTo();
        return this;
    }

    public NumberRange getRange() {
        return this.from == null && this.to == null ? null : new NumberRange(this.from, this.to);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NumberRangeFilter)) {
            return false;
        }
        NumberRangeFilter that = (NumberRangeFilter)o;
        return this.name.equals(that.name) && Objects.equals(this.from, that.from) && Objects.equals(this.to, that.to);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.from, this.to);
    }

    public String getName() {
        return this.name;
    }

    public BigDecimal getFrom() {
        return this.from;
    }

    public BigDecimal getTo() {
        return this.to;
    }

    public NumberRangeFilter setFrom(BigDecimal from) {
        this.from = from;
        return this;
    }

    public NumberRangeFilter setTo(BigDecimal to) {
        this.to = to;
        return this;
    }

    public NumberRangeFilter(String name) {
        this.name = name;
    }

    public String toString() {
        return "NumberRangeFilter(name=" + this.getName() + ", from=" + this.getFrom() + ", to=" + this.getTo() + ")";
    }
}

