/*
 * Decompiled with CFR 0.152.
 */
package co.elasticsearch.enterprisesearch.client.model.response.documents;

import co.elasticsearch.enterprisesearch.client.model.response.ErrorableResponse;
import co.elasticsearch.enterprisesearch.client.model.response.documents.DeleteResult;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class DeleteResponse
implements ErrorableResponse {
    private List<DeleteResult> documents = new ArrayList<DeleteResult>();

    @Override
    @JsonIgnore
    public boolean isError() {
        return this.documents.stream().anyMatch(dr -> !dr.isDeleted());
    }

    public List<DeleteResult> getErrors() {
        return this.documents.stream().filter(d -> !d.isDeleted()).collect(Collectors.toList());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DeleteResponse)) {
            return false;
        }
        DeleteResponse that = (DeleteResponse)o;
        return this.documents.equals(that.documents);
    }

    public int hashCode() {
        return Objects.hash(this.documents);
    }

    public List<DeleteResult> getDocuments() {
        return this.documents;
    }

    public DeleteResponse setDocuments(List<DeleteResult> documents) {
        this.documents = documents;
        return this;
    }

    public String toString() {
        return "DeleteResponse(documents=" + this.getDocuments() + ")";
    }
}

