/*
 * Decompiled with CFR 0.152.
 */
package co.elasticsearch.enterprisesearch.client.model.response.search.facet;

import co.elasticsearch.enterprisesearch.client.model.DeserializationUtil;
import co.elasticsearch.enterprisesearch.client.model.FacetType;
import co.elasticsearch.enterprisesearch.client.model.response.search.facet.DateRangeFacet;
import co.elasticsearch.enterprisesearch.client.model.response.search.facet.DateValueFacet;
import co.elasticsearch.enterprisesearch.client.model.response.search.facet.EmptyRangeFacet;
import co.elasticsearch.enterprisesearch.client.model.response.search.facet.EmptyValueFacet;
import co.elasticsearch.enterprisesearch.client.model.response.search.facet.Facet;
import co.elasticsearch.enterprisesearch.client.model.response.search.facet.NumberRangeFacet;
import co.elasticsearch.enterprisesearch.client.model.response.search.facet.NumberValueFacet;
import co.elasticsearch.enterprisesearch.client.model.response.search.facet.TextValueFacet;
import co.elasticsearch.enterprisesearch.client.model.response.search.facet.value.DateRange;
import co.elasticsearch.enterprisesearch.client.model.response.search.facet.value.DateValue;
import co.elasticsearch.enterprisesearch.client.model.response.search.facet.value.NumberRange;
import co.elasticsearch.enterprisesearch.client.model.response.search.facet.value.NumberValue;
import co.elasticsearch.enterprisesearch.client.model.response.search.facet.value.TextValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.io.IOException;
import java.util.ArrayList;

public class FacetDeserializer
extends StdDeserializer<Facet> {
    protected FacetDeserializer() {
        super(Facet.class);
    }

    public Facet deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        String name;
        TreeNode node = jsonParser.readValueAsTree();
        TreeNode typeNode = node.get("type");
        TextNode type = (TextNode)typeNode;
        FacetType facetType = FacetType.fromValue(type.textValue());
        TextNode nameNode = (TextNode)node.get("name");
        ArrayNode dataArray = (ArrayNode)node.get("data");
        String string = name = nameNode == null ? null : nameNode.asText();
        if (FacetType.RANGE.equals((Object)facetType)) {
            if (dataArray.isEmpty()) {
                return new EmptyRangeFacet().setName(name);
            }
            JsonNode firstValue = DeserializationUtil.getFirstValue((TreeNode)dataArray);
            JsonNode firstTo = firstValue.get("to");
            JsonNode firstFrom = firstValue.get("from");
            if (firstFrom != null && firstFrom.isNumber() || firstTo != null && firstTo.isNumber()) {
                ArrayList<NumberRange> dataValues = new ArrayList<NumberRange>();
                for (JsonNode d : dataArray) {
                    dataValues.add((NumberRange)jsonParser.getCodec().treeToValue((TreeNode)d, NumberRange.class));
                }
                return new NumberRangeFacet().setData(dataValues).setName(name);
            }
            ArrayList<DateRange> dateRange = new ArrayList<DateRange>();
            for (JsonNode d : dataArray) {
                dateRange.add((DateRange)jsonParser.getCodec().treeToValue((TreeNode)d, DateRange.class));
            }
            return new DateRangeFacet().setData(dateRange).setName(name);
        }
        JsonNode firstValue = DeserializationUtil.getFirstValue((TreeNode)dataArray);
        if (dataArray.isEmpty()) {
            return new EmptyValueFacet().setName(name);
        }
        JsonNode valueNode = firstValue.get("value");
        if (valueNode.asToken().isNumeric()) {
            ArrayList<NumberValue> numberValues = new ArrayList<NumberValue>();
            for (JsonNode d : dataArray) {
                numberValues.add((NumberValue)jsonParser.getCodec().treeToValue((TreeNode)d, NumberValue.class));
            }
            return new NumberValueFacet().setData(numberValues).setName(name);
        }
        if (DeserializationUtil.isDate((TextNode)valueNode)) {
            ArrayList<DateValue> dateValues = new ArrayList<DateValue>();
            for (JsonNode d : dataArray) {
                dateValues.add((DateValue)jsonParser.getCodec().treeToValue((TreeNode)d, DateValue.class));
            }
            return new DateValueFacet().setData(dateValues).setName(name);
        }
        ArrayList<TextValue> textValues = new ArrayList<TextValue>();
        for (JsonNode d : dataArray) {
            textValues.add((TextValue)jsonParser.getCodec().treeToValue((TreeNode)d, TextValue.class));
        }
        return new TextValueFacet().setData(textValues).setName(name);
    }
}

