/*
 * Decompiled with CFR 0.152.
 */
package co.elasticsearch.enterprisesearch.client.model.response.searchsettings;

import co.elasticsearch.enterprisesearch.client.model.request.search.ResultField;
import co.elasticsearch.enterprisesearch.client.model.request.search.SearchField;
import co.elasticsearch.enterprisesearch.client.model.request.search.boost.Boost;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@JsonPropertyOrder(value={"search_fields", "result_fields", "boosts", "precision", "precision_enabled"})
public class SearchSettings {
    @JsonProperty(value="search_fields")
    private Map<String, SearchField> searchFieldMap = new LinkedHashMap<String, SearchField>();
    @JsonProperty(value="result_fields")
    private Map<String, ResultField> resultFieldMap = new HashMap<String, ResultField>();
    @JsonProperty(value="boosts")
    @JsonFormat(with={JsonFormat.Feature.ACCEPT_SINGLE_VALUE_AS_ARRAY, JsonFormat.Feature.WRITE_SINGLE_ELEM_ARRAYS_UNWRAPPED})
    private Map<String, List<Boost>> boostMap = new LinkedHashMap<String, List<Boost>>();
    private Integer precision;
    @JsonProperty(value="precision_enabled")
    private Boolean precisionEnabled;

    @JsonIgnore
    public Collection<ResultField> getResults() {
        return this.resultFieldMap.values();
    }

    @JsonIgnore
    public SearchSettings addResultField(ResultField resultField) {
        this.resultFieldMap.put(resultField.getName(), resultField);
        return this;
    }

    void setResultFieldMap(Map<String, ResultField> resultFieldMap) {
        for (Map.Entry<String, ResultField> entry : resultFieldMap.entrySet()) {
            entry.getValue().setName(entry.getKey());
        }
        this.resultFieldMap = resultFieldMap;
    }

    @JsonIgnore
    public SearchSettings addSearchField(SearchField searchField) {
        this.searchFieldMap.put(searchField.getName(), searchField);
        return this;
    }

    @JsonIgnore
    public Collection<SearchField> getSearchFields() {
        return this.searchFieldMap.values();
    }

    void setSearchFieldMap(Map<String, SearchField> searchFieldMap) {
        for (Map.Entry<String, SearchField> searchField : searchFieldMap.entrySet()) {
            searchField.getValue().setName(searchField.getKey());
        }
        this.searchFieldMap = searchFieldMap;
    }

    @JsonIgnore
    public List<Boost> getBoosts() {
        return this.boostMap.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    public SearchSettings addBoost(Boost boost) {
        this.boostMap.putIfAbsent(boost.getName(), new ArrayList());
        this.boostMap.get(boost.getName()).add(boost);
        return this;
    }

    void setBoostMap(Map<String, List<Boost>> boostMap) {
        for (Map.Entry<String, List<Boost>> boost : boostMap.entrySet()) {
            for (Boost b : boost.getValue()) {
                b.setName(boost.getKey());
            }
        }
        this.boostMap = boostMap;
    }

    public Integer getPrecision() {
        return this.precision;
    }

    public Boolean getPrecisionEnabled() {
        return this.precisionEnabled;
    }

    public SearchSettings setPrecision(Integer precision) {
        this.precision = precision;
        return this;
    }

    @JsonProperty(value="precision_enabled")
    public SearchSettings setPrecisionEnabled(Boolean precisionEnabled) {
        this.precisionEnabled = precisionEnabled;
        return this;
    }

    Map<String, SearchField> getSearchFieldMap() {
        return this.searchFieldMap;
    }

    Map<String, ResultField> getResultFieldMap() {
        return this.resultFieldMap;
    }

    Map<String, List<Boost>> getBoostMap() {
        return this.boostMap;
    }
}

