/*
 * Decompiled with CFR 0.152.
 */
package co.elasticsearch.enterprisesearch.client.model;

import co.elasticsearch.enterprisesearch.client.model.request.search.filter.DateValueFilter;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.time.OffsetDateTime;
import java.time.format.DateTimeParseException;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public final class DeserializationUtil {
    public static JsonNode getFirstValue(TreeNode filterNode) {
        if (filterNode instanceof ArrayNode) {
            return (JsonNode)((ArrayNode)filterNode).elements().next();
        }
        return (JsonNode)filterNode;
    }

    public static Stream<JsonNode> getNodeStream(TreeNode filterNode) {
        if (filterNode instanceof ArrayNode) {
            ArrayNode filterValues = (ArrayNode)filterNode;
            return StreamSupport.stream(filterValues.spliterator(), false);
        }
        return Stream.of((JsonNode)filterNode);
    }

    public static boolean isDate(TextNode text) {
        try {
            OffsetDateTime.parse(text.asText(), DateValueFilter.RFC_3339);
            return true;
        }
        catch (DateTimeParseException e) {
            return false;
        }
    }

    private DeserializationUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

