/*
 * Decompiled with CFR 0.152.
 */
package co.elasticsearch.enterprisesearch.client.model.request.search;

import co.elasticsearch.enterprisesearch.client.model.Sort;
import co.elasticsearch.enterprisesearch.client.model.request.Page;
import co.elasticsearch.enterprisesearch.client.model.request.search.Analytics;
import co.elasticsearch.enterprisesearch.client.model.request.search.Group;
import co.elasticsearch.enterprisesearch.client.model.request.search.ResultField;
import co.elasticsearch.enterprisesearch.client.model.request.search.SearchField;
import co.elasticsearch.enterprisesearch.client.model.request.search.boost.Boost;
import co.elasticsearch.enterprisesearch.client.model.request.search.facet.Facet;
import co.elasticsearch.enterprisesearch.client.model.request.search.filter.Filter;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class SearchRequest {
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    private String query = "";
    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=Page.class)
    private Page page = new Page();
    private List<Sort> sort = new ArrayList<Sort>();
    private Group group = null;
    @JsonProperty(value="facets")
    private Map<String, List<Facet>> facetMap = new LinkedHashMap<String, List<Facet>>();
    private Filter filters;
    @Min(value=1L)
    @Max(value=11L)
    private @Min(value=1L) @Max(value=11L) Integer precision;
    @JsonProperty(value="boosts")
    @JsonFormat(with={JsonFormat.Feature.ACCEPT_SINGLE_VALUE_AS_ARRAY, JsonFormat.Feature.WRITE_SINGLE_ELEM_ARRAYS_UNWRAPPED})
    private Map<String, List<Boost>> boostMap = new LinkedHashMap<String, List<Boost>>();
    @JsonProperty(value="search_fields")
    private Map<String, SearchField> searchFieldMap = new LinkedHashMap<String, SearchField>();
    @JsonProperty(value="result_fields")
    private Map<String, ResultField> resultFieldMap = new LinkedHashMap<String, ResultField>();
    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=Analytics.class)
    private Analytics analytics = new Analytics();
    @JsonProperty(value="record_analytics")
    private Boolean recordAnalytics;

    public SearchRequest withSorts(Sort ... sorts) {
        this.sort = Arrays.asList(sorts);
        return this;
    }

    public SearchRequest withTags(String ... tags) {
        this.analytics.withTags(tags);
        return this;
    }

    public SearchRequest withFacets(Facet ... facets) {
        for (Facet facet : facets) {
            this.facetMap.putIfAbsent(facet.getFieldName(), new ArrayList());
            this.facetMap.get(facet.getFieldName()).add(facet);
        }
        return this;
    }

    public SearchRequest withBoosts(Boost ... boosts) {
        for (Boost boost : boosts) {
            this.boostMap.put(boost.getName(), Collections.singletonList(boost));
        }
        return this;
    }

    public SearchRequest withSearchFields(SearchField ... fields) {
        for (SearchField field : fields) {
            this.searchFieldMap.put(field.getName(), field);
        }
        return this;
    }

    public SearchRequest withResultFields(ResultField ... fields) {
        for (ResultField field : fields) {
            this.resultFieldMap.put(field.getName(), field);
        }
        return this;
    }

    @JsonIgnore
    public List<Boost> getBoosts() {
        return this.boostMap.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    @JsonIgnore
    public List<SearchField> getSearchFields() {
        return new ArrayList<SearchField>(this.searchFieldMap.values());
    }

    @JsonIgnore
    public List<ResultField> getResultFields() {
        return new ArrayList<ResultField>(this.resultFieldMap.values());
    }

    @JsonIgnore
    public List<Facet> getFacets() {
        return this.facetMap.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    void setBoostMap(Map<String, List<Boost>> boosts) {
        for (Map.Entry<String, List<Boost>> field : boosts.entrySet()) {
            for (Boost b : field.getValue()) {
                b.setName(field.getKey());
            }
        }
        this.boostMap = boosts;
    }

    void setSearchFieldMap(Map<String, SearchField> searchFieldMap) {
        for (Map.Entry<String, SearchField> field : searchFieldMap.entrySet()) {
            field.getValue().setName(field.getKey());
        }
        this.searchFieldMap = searchFieldMap;
    }

    void setResultFieldMap(Map<String, ResultField> resultFieldMap) {
        for (Map.Entry<String, ResultField> field : resultFieldMap.entrySet()) {
            field.getValue().setName(field.getKey());
        }
        this.resultFieldMap = resultFieldMap;
    }

    void setFacetMap(Map<String, List<Facet>> facetMap) {
        for (Map.Entry<String, List<Facet>> facet : facetMap.entrySet()) {
            facet.getValue().forEach(f -> f.setFieldName((String)facet.getKey()));
        }
        this.facetMap = facetMap;
    }

    public String getQuery() {
        return this.query;
    }

    public Page getPage() {
        return this.page;
    }

    public List<Sort> getSort() {
        return this.sort;
    }

    public Group getGroup() {
        return this.group;
    }

    public Filter getFilters() {
        return this.filters;
    }

    public Integer getPrecision() {
        return this.precision;
    }

    public Analytics getAnalytics() {
        return this.analytics;
    }

    public Boolean getRecordAnalytics() {
        return this.recordAnalytics;
    }

    public SearchRequest setQuery(String query) {
        this.query = query;
        return this;
    }

    public SearchRequest setPage(Page page) {
        this.page = page;
        return this;
    }

    public SearchRequest setSort(List<Sort> sort) {
        this.sort = sort;
        return this;
    }

    public SearchRequest setGroup(Group group) {
        this.group = group;
        return this;
    }

    public SearchRequest setFilters(Filter filters) {
        this.filters = filters;
        return this;
    }

    public SearchRequest setPrecision(Integer precision) {
        this.precision = precision;
        return this;
    }

    public SearchRequest setAnalytics(Analytics analytics) {
        this.analytics = analytics;
        return this;
    }

    @JsonProperty(value="record_analytics")
    public SearchRequest setRecordAnalytics(Boolean recordAnalytics) {
        this.recordAnalytics = recordAnalytics;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SearchRequest)) {
            return false;
        }
        SearchRequest other = (SearchRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$precision = this.getPrecision();
        Integer other$precision = other.getPrecision();
        if (this$precision == null ? other$precision != null : !((Object)this$precision).equals(other$precision)) {
            return false;
        }
        Boolean this$recordAnalytics = this.getRecordAnalytics();
        Boolean other$recordAnalytics = other.getRecordAnalytics();
        if (this$recordAnalytics == null ? other$recordAnalytics != null : !((Object)this$recordAnalytics).equals(other$recordAnalytics)) {
            return false;
        }
        String this$query = this.getQuery();
        String other$query = other.getQuery();
        if (this$query == null ? other$query != null : !this$query.equals(other$query)) {
            return false;
        }
        Page this$page = this.getPage();
        Page other$page = other.getPage();
        if (this$page == null ? other$page != null : !((Object)this$page).equals(other$page)) {
            return false;
        }
        List<Sort> this$sort = this.getSort();
        List<Sort> other$sort = other.getSort();
        if (this$sort == null ? other$sort != null : !((Object)this$sort).equals(other$sort)) {
            return false;
        }
        Group this$group = this.getGroup();
        Group other$group = other.getGroup();
        if (this$group == null ? other$group != null : !((Object)this$group).equals(other$group)) {
            return false;
        }
        Map<String, List<Facet>> this$facetMap = this.getFacetMap();
        Map<String, List<Facet>> other$facetMap = other.getFacetMap();
        if (this$facetMap == null ? other$facetMap != null : !((Object)this$facetMap).equals(other$facetMap)) {
            return false;
        }
        Filter this$filters = this.getFilters();
        Filter other$filters = other.getFilters();
        if (this$filters == null ? other$filters != null : !this$filters.equals(other$filters)) {
            return false;
        }
        Map<String, List<Boost>> this$boostMap = this.getBoostMap();
        Map<String, List<Boost>> other$boostMap = other.getBoostMap();
        if (this$boostMap == null ? other$boostMap != null : !((Object)this$boostMap).equals(other$boostMap)) {
            return false;
        }
        Map<String, SearchField> this$searchFieldMap = this.getSearchFieldMap();
        Map<String, SearchField> other$searchFieldMap = other.getSearchFieldMap();
        if (this$searchFieldMap == null ? other$searchFieldMap != null : !((Object)this$searchFieldMap).equals(other$searchFieldMap)) {
            return false;
        }
        Map<String, ResultField> this$resultFieldMap = this.getResultFieldMap();
        Map<String, ResultField> other$resultFieldMap = other.getResultFieldMap();
        if (this$resultFieldMap == null ? other$resultFieldMap != null : !((Object)this$resultFieldMap).equals(other$resultFieldMap)) {
            return false;
        }
        Analytics this$analytics = this.getAnalytics();
        Analytics other$analytics = other.getAnalytics();
        return !(this$analytics == null ? other$analytics != null : !((Object)this$analytics).equals(other$analytics));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SearchRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $precision = this.getPrecision();
        result = result * 59 + ($precision == null ? 43 : ((Object)$precision).hashCode());
        Boolean $recordAnalytics = this.getRecordAnalytics();
        result = result * 59 + ($recordAnalytics == null ? 43 : ((Object)$recordAnalytics).hashCode());
        String $query = this.getQuery();
        result = result * 59 + ($query == null ? 43 : $query.hashCode());
        Page $page = this.getPage();
        result = result * 59 + ($page == null ? 43 : ((Object)$page).hashCode());
        List<Sort> $sort = this.getSort();
        result = result * 59 + ($sort == null ? 43 : ((Object)$sort).hashCode());
        Group $group = this.getGroup();
        result = result * 59 + ($group == null ? 43 : ((Object)$group).hashCode());
        Map<String, List<Facet>> $facetMap = this.getFacetMap();
        result = result * 59 + ($facetMap == null ? 43 : ((Object)$facetMap).hashCode());
        Filter $filters = this.getFilters();
        result = result * 59 + ($filters == null ? 43 : $filters.hashCode());
        Map<String, List<Boost>> $boostMap = this.getBoostMap();
        result = result * 59 + ($boostMap == null ? 43 : ((Object)$boostMap).hashCode());
        Map<String, SearchField> $searchFieldMap = this.getSearchFieldMap();
        result = result * 59 + ($searchFieldMap == null ? 43 : ((Object)$searchFieldMap).hashCode());
        Map<String, ResultField> $resultFieldMap = this.getResultFieldMap();
        result = result * 59 + ($resultFieldMap == null ? 43 : ((Object)$resultFieldMap).hashCode());
        Analytics $analytics = this.getAnalytics();
        result = result * 59 + ($analytics == null ? 43 : ((Object)$analytics).hashCode());
        return result;
    }

    public String toString() {
        return "SearchRequest(query=" + this.getQuery() + ", page=" + this.getPage() + ", sort=" + this.getSort() + ", group=" + this.getGroup() + ", facetMap=" + this.getFacetMap() + ", filters=" + this.getFilters() + ", precision=" + this.getPrecision() + ", boostMap=" + this.getBoostMap() + ", searchFieldMap=" + this.getSearchFieldMap() + ", resultFieldMap=" + this.getResultFieldMap() + ", analytics=" + this.getAnalytics() + ", recordAnalytics=" + this.getRecordAnalytics() + ")";
    }

    Map<String, List<Facet>> getFacetMap() {
        return this.facetMap;
    }

    Map<String, List<Boost>> getBoostMap() {
        return this.boostMap;
    }

    Map<String, SearchField> getSearchFieldMap() {
        return this.searchFieldMap;
    }

    Map<String, ResultField> getResultFieldMap() {
        return this.resultFieldMap;
    }
}

