/*
 * Decompiled with CFR 0.152.
 */
package co.elasticsearch.enterprisesearch.client.model.request.search.boost;

import co.elasticsearch.enterprisesearch.client.model.request.search.boost.BoostDeserializer;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.math.BigDecimal;
import java.util.Arrays;

@JsonDeserialize(using=BoostDeserializer.class)
public interface Boost {
    @JsonIgnore
    public String getName();

    @JsonIgnore
    public Boost setName(String var1);

    public BoostType getType();

    public BigDecimal getFactor();

    public Boost setFactor(BigDecimal var1);

    public static enum Operation {
        ADD("add"),
        MULTIPLY("multiply");

        @JsonValue
        private final String value;

        @JsonCreator
        public static Operation findByValue(String value) {
            return Arrays.stream(Operation.values()).filter(v -> v.value.equals(value)).findFirst().orElseThrow();
        }

        public String getValue() {
            return this.value;
        }

        private Operation(String value) {
            this.value = value;
        }
    }

    public static enum Function {
        LINEAR("linear"),
        EXPONENTIAL("exponential"),
        GAUSSIAN("gaussian"),
        LOGARITHMIC("logarithmic");

        @JsonValue
        private final String value;

        @JsonCreator
        public static Function findByValue(String value) {
            return Arrays.stream(Function.values()).filter(v -> v.value.equals(value)).findFirst().orElseThrow();
        }

        public String getValue() {
            return this.value;
        }

        private Function(String value) {
            this.value = value;
        }
    }

    public static enum BoostType {
        FUNCTIONAL("functional"),
        VALUE("value"),
        PROXIMITY("proximity");

        @JsonValue
        private final String value;

        public static BoostType findByValue(String value) {
            return Arrays.stream(BoostType.values()).filter(v -> v.value.equals(value)).findFirst().orElse(null);
        }

        public String getValue() {
            return this.value;
        }

        private BoostType(String value) {
            this.value = value;
        }
    }
}

