/*
 * Decompiled with CFR 0.152.
 */
package co.elasticsearch.enterprisesearch.client.model.request.search.filter;

import co.elasticsearch.enterprisesearch.client.model.request.search.filter.Filter;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class NumberValueFilter
implements Filter {
    private final String name;
    @JsonFormat(with={JsonFormat.Feature.ACCEPT_SINGLE_VALUE_AS_ARRAY, JsonFormat.Feature.WRITE_SINGLE_ELEM_ARRAYS_UNWRAPPED})
    private List<BigDecimal> values = new ArrayList<BigDecimal>();

    public NumberValueFilter(String name, BigDecimal ... values) {
        this(name);
        this.values.addAll(Arrays.asList(values));
    }

    public NumberValueFilter(String name, Integer ... values) {
        this(name);
        this.values.addAll(Arrays.stream(values).map(BigDecimal::new).collect(Collectors.toList()));
    }

    public NumberValueFilter(String name, Long ... values) {
        this(name);
        this.values.addAll(Arrays.stream(values).map(BigDecimal::new).collect(Collectors.toList()));
    }

    public NumberValueFilter(String name, Float ... values) {
        this(name);
        this.values.addAll(Arrays.stream(values).map(BigDecimal::valueOf).collect(Collectors.toList()));
    }

    public NumberValueFilter(String name, Double ... values) {
        this(name);
        this.values.addAll(Arrays.stream(values).map(BigDecimal::valueOf).collect(Collectors.toList()));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NumberValueFilter)) {
            return false;
        }
        NumberValueFilter that = (NumberValueFilter)o;
        return this.name.equals(that.name) && this.values.equals(that.values);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.values);
    }

    public String getName() {
        return this.name;
    }

    public List<BigDecimal> getValues() {
        return this.values;
    }

    @JsonFormat(with={JsonFormat.Feature.ACCEPT_SINGLE_VALUE_AS_ARRAY, JsonFormat.Feature.WRITE_SINGLE_ELEM_ARRAYS_UNWRAPPED})
    public NumberValueFilter setValues(List<BigDecimal> values) {
        this.values = values;
        return this;
    }

    public NumberValueFilter(String name) {
        this.name = name;
    }

    public String toString() {
        return "NumberValueFilter(name=" + this.getName() + ", values=" + this.getValues() + ")";
    }
}

