/*
 * Decompiled with CFR 0.152.
 */
package co.elasticsearch.enterprisesearch.client.model.request.search.range;

import co.elasticsearch.enterprisesearch.client.model.request.search.range.Range;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.math.BigDecimal;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonDeserialize
public class NumberRange
implements Range<BigDecimal> {
    private BigDecimal from;
    private BigDecimal to;
    private String name;

    public NumberRange() {
    }

    public NumberRange(BigDecimal from, BigDecimal to) {
        this.from = from;
        this.to = to;
    }

    public NumberRange(String from, String to) {
        if (from != null) {
            this.from = new BigDecimal(from);
        }
        if (to != null) {
            this.to = new BigDecimal(to);
        }
    }

    public NumberRange(Integer from, Integer to) {
        if (from != null) {
            this.from = new BigDecimal(from);
        }
        if (to != null) {
            this.to = new BigDecimal(to);
        }
    }

    public NumberRange(Long from, Long to) {
        if (from != null) {
            this.from = new BigDecimal(from);
        }
        if (to != null) {
            this.to = new BigDecimal(to);
        }
    }

    public NumberRange(Float from, Float to) {
        if (from != null) {
            this.from = BigDecimal.valueOf(from.floatValue());
        }
        if (to != null) {
            this.to = BigDecimal.valueOf(to.floatValue());
        }
    }

    public NumberRange(Double from, Double to) {
        if (from != null) {
            this.from = BigDecimal.valueOf(from);
        }
        if (to != null) {
            this.to = BigDecimal.valueOf(to);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NumberRange)) {
            return false;
        }
        NumberRange that = (NumberRange)o;
        return Objects.equals(this.from, that.from) && Objects.equals(this.to, that.to) && Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.from, this.to, this.name);
    }

    @Override
    public BigDecimal getFrom() {
        return this.from;
    }

    @Override
    public BigDecimal getTo() {
        return this.to;
    }

    public String getName() {
        return this.name;
    }

    public NumberRange setFrom(BigDecimal from) {
        this.from = from;
        return this;
    }

    public NumberRange setTo(BigDecimal to) {
        this.to = to;
        return this;
    }

    public NumberRange setName(String name) {
        this.name = name;
        return this;
    }

    public String toString() {
        return "NumberRange(from=" + this.getFrom() + ", to=" + this.getTo() + ", name=" + this.getName() + ")";
    }
}

