/*
 * Decompiled with CFR 0.152.
 */
package co.elasticsearch.enterprisesearch.client.model.request.search.range;

import co.elasticsearch.enterprisesearch.client.model.request.search.range.DateRange;
import co.elasticsearch.enterprisesearch.client.model.request.search.range.NumberRange;
import co.elasticsearch.enterprisesearch.client.model.request.search.range.Range;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.node.NumericNode;
import java.io.IOException;

class RangeDeserializer
extends StdDeserializer<Range> {
    protected RangeDeserializer() {
        super(Range.class);
    }

    public Range deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        TreeNode node = jsonParser.readValueAsTree();
        TreeNode to = node.get("to");
        TreeNode from = node.get("from");
        if (to instanceof NumericNode || from instanceof NumericNode) {
            return (Range)jsonParser.getCodec().treeToValue(node, NumberRange.class);
        }
        return (Range)jsonParser.getCodec().treeToValue(node, DateRange.class);
    }
}

