/*
 * Decompiled with CFR 0.152.
 */
package co.elasticsearch.enterprisesearch.client;

import co.elasticsearch.enterprisesearch.client.ClientAuthentication;
import co.elasticsearch.enterprisesearch.client.DocumentsApi;
import co.elasticsearch.enterprisesearch.client.DocumentsApiImpl;
import co.elasticsearch.enterprisesearch.client.EnginesApi;
import co.elasticsearch.enterprisesearch.client.EnginesApiImpl;
import co.elasticsearch.enterprisesearch.client.EnterpriseSearchAuthInterceptor;
import co.elasticsearch.enterprisesearch.client.QuerySuggestionsApi;
import co.elasticsearch.enterprisesearch.client.QuerySuggestionsApiImpl;
import co.elasticsearch.enterprisesearch.client.SchemaApi;
import co.elasticsearch.enterprisesearch.client.SchemaApiImpl;
import co.elasticsearch.enterprisesearch.client.SearchApi;
import co.elasticsearch.enterprisesearch.client.SearchApiImpl;
import co.elasticsearch.enterprisesearch.client.SearchSettingsApi;
import co.elasticsearch.enterprisesearch.client.SearchSettingsApiImpl;
import co.elasticsearch.enterprisesearch.client.SourceEnginesApi;
import co.elasticsearch.enterprisesearch.client.SourceEnginesApiImpl;
import co.elasticsearch.enterprisesearch.client.model.response.search.ResponseDocument;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.util.concurrent.TimeUnit;
import okhttp3.ConnectionPool;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppSearchClient {
    private static final Logger log = LoggerFactory.getLogger(AppSearchClient.class);
    static final MediaType APP_JSON = MediaType.parse((String)"application/json");
    private final ObjectMapper objectMapper = ((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().addModule((Module)new JavaTimeModule())).disable(new SerializationFeature[]{SerializationFeature.WRITE_DATES_AS_TIMESTAMPS})).build();
    private final String baseUrl;
    private final OkHttpClient client;

    public static Builder builder(String baseUrl) {
        return new Builder(baseUrl);
    }

    public <T> DocumentsApi<T> documents(Class<T> documentType) {
        return new DocumentsApiImpl<T>(this.objectMapper, this.baseUrl, this.client, documentType);
    }

    public <T extends ResponseDocument> SearchApi<T> search(Class<T> resultType) {
        return new SearchApiImpl<T>(this.objectMapper, this.baseUrl, this.client, resultType);
    }

    public EnginesApi engines() {
        return new EnginesApiImpl(this.objectMapper, this.baseUrl, this.client);
    }

    public SchemaApi schemas() {
        return new SchemaApiImpl(this.objectMapper, this.baseUrl, this.client);
    }

    public SearchSettingsApi searchSettings() {
        return new SearchSettingsApiImpl(this.objectMapper, this.baseUrl, this.client);
    }

    public SourceEnginesApi sourceEngines() {
        return new SourceEnginesApiImpl(this.objectMapper, this.baseUrl, this.client);
    }

    public QuerySuggestionsApi querySuggestions() {
        return new QuerySuggestionsApiImpl(this.objectMapper, this.baseUrl, this.client);
    }

    public AppSearchClient(String baseUrl, OkHttpClient client) {
        this.baseUrl = baseUrl;
        this.client = client;
    }

    public static class Builder {
        private final String endpointBase;
        private ClientAuthentication clientAuthentication;
        private OkHttpClient.Builder clientBuilder = new OkHttpClient.Builder().connectionPool(new ConnectionPool(10, 10L, TimeUnit.SECONDS));

        public AppSearchClient build() {
            this.clientBuilder.addInterceptor((Interceptor)EnterpriseSearchAuthInterceptor.builder().auth(this.clientAuthentication).build()).build();
            return new AppSearchClient(this.endpointBase, this.clientBuilder.build());
        }

        public Builder(String endpointBase) {
            this.endpointBase = endpointBase;
        }

        public Builder clientAuthentication(ClientAuthentication clientAuthentication) {
            this.clientAuthentication = clientAuthentication;
            return this;
        }

        public Builder clientBuilder(OkHttpClient.Builder clientBuilder) {
            this.clientBuilder = clientBuilder;
            return this;
        }
    }
}

