/*
 * Decompiled with CFR 0.152.
 */
package co.elasticsearch.enterprisesearch.client;

import co.elasticsearch.enterprisesearch.client.ClientUtils;
import co.elasticsearch.enterprisesearch.client.QuerySuggestionsApi;
import co.elasticsearch.enterprisesearch.client.model.request.querysuggestions.QuerySuggestionsRequest;
import co.elasticsearch.enterprisesearch.client.model.response.querysuggestions.QuerySuggestionsResponse;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Objects;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class QuerySuggestionsApiImpl
implements QuerySuggestionsApi {
    private static final Logger log = LoggerFactory.getLogger(QuerySuggestionsApiImpl.class);
    private final ObjectMapper objectMapper;
    private final String baseUrl;
    private final OkHttpClient client;
    private static final String QUERY_SUGGESTIONS_PATH = "/api/as/v1/engines/{engineName}/query_suggestion";

    @Override
    public QuerySuggestionsResponse getQuerySuggestion(String engine, QuerySuggestionsRequest request) {
        HttpUrl url = Objects.requireNonNull(HttpUrl.parse((String)(this.baseUrl + QUERY_SUGGESTIONS_PATH))).newBuilder().setPathSegment(4, engine).build();
        log.debug("Getting QuerySuggestions for {} , request:{}", (Object)url, (Object)request);
        Request okRequest = new Request.Builder().url(url).post(ClientUtils.marshalPayload(this.objectMapper, request)).build();
        return ClientUtils.marshalResponse(this.client, okRequest, this.objectMapper, QuerySuggestionsResponse.class);
    }

    public QuerySuggestionsApiImpl(ObjectMapper objectMapper, String baseUrl, OkHttpClient client) {
        this.objectMapper = objectMapper;
        this.baseUrl = baseUrl;
        this.client = client;
    }
}

