/*
 * Decompiled with CFR 0.152.
 */
package co.elasticsearch.enterprisesearch.client;

import co.elasticsearch.enterprisesearch.client.ClientUtils;
import co.elasticsearch.enterprisesearch.client.SearchSettingsApi;
import co.elasticsearch.enterprisesearch.client.model.response.searchsettings.SearchSettings;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Objects;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SearchSettingsApiImpl
implements SearchSettingsApi {
    private static final Logger log = LoggerFactory.getLogger(SearchSettingsApiImpl.class);
    private final ObjectMapper objectMapper;
    private final String baseUrl;
    private final OkHttpClient client;
    private static final String SEARCH_SETTINGS_PATH = "/api/as/v1/engines/{engineName}/search_settings";

    @Override
    public SearchSettings get(String engineName) {
        HttpUrl url = Objects.requireNonNull(HttpUrl.parse((String)(this.baseUrl + SEARCH_SETTINGS_PATH))).newBuilder().setPathSegment(4, engineName).build();
        Request okRequest = new Request.Builder().url(url).get().build();
        return ClientUtils.marshalResponse(this.client, okRequest, this.objectMapper, SearchSettings.class);
    }

    @Override
    public SearchSettings update(String engineName, SearchSettings settings) {
        HttpUrl url = Objects.requireNonNull(HttpUrl.parse((String)(this.baseUrl + SEARCH_SETTINGS_PATH))).newBuilder().setPathSegment(4, engineName).build();
        log.debug("Updating Search Settings {} , Settings:{}", (Object)url, (Object)settings);
        Request okRequest = new Request.Builder().url(url).put(ClientUtils.marshalPayload(this.objectMapper, settings)).build();
        return ClientUtils.marshalResponse(this.client, okRequest, this.objectMapper, SearchSettings.class);
    }

    @Override
    public SearchSettings reset(String engineName) {
        HttpUrl url = Objects.requireNonNull(HttpUrl.parse((String)(this.baseUrl + "/api/as/v1/engines/{engineName}/search_settings/reset"))).newBuilder().setPathSegment(4, engineName).build();
        log.debug("Resetting Search Settings {}", (Object)url);
        Request okRequest = new Request.Builder().url(url).post(RequestBody.create((String)"", null)).build();
        return ClientUtils.marshalResponse(this.client, okRequest, this.objectMapper, SearchSettings.class);
    }

    public SearchSettingsApiImpl(ObjectMapper objectMapper, String baseUrl, OkHttpClient client) {
        this.objectMapper = objectMapper;
        this.baseUrl = baseUrl;
        this.client = client;
    }
}

