/*
 * Decompiled with CFR 0.152.
 */
package co.elasticsearch.enterprisesearch.client.model;

import co.elasticsearch.enterprisesearch.client.model.GeolocationDeserializer;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(using=GeolocationDeserializer.class)
public class Geolocation {
    static final Pattern LATITUDE_LONGITUDE = Pattern.compile("^([+-]?\\d{1,3}(\\.\\d+)?),\\s?([+-]?\\d{1,3}(\\.\\d+)?)$");
    static final Pattern WELL_KNOWN_TEXT_POINT = Pattern.compile("^POINT \\(([+-]?\\d{1,3}(\\.\\d+)) ([+-]?\\d{1,3}(\\.\\d+))\\)");
    @JsonIgnore
    private final BigDecimal latitude;
    @JsonIgnore
    private final BigDecimal longitude;

    @JsonValue
    public BigDecimal[] getCenter() {
        return new BigDecimal[]{this.longitude, this.latitude};
    }

    public Geolocation(BigDecimal latitude, BigDecimal longitude) {
        Geolocation.validate(latitude, longitude);
        this.longitude = longitude;
        this.latitude = latitude;
    }

    public Geolocation(String latitude, String longitude) {
        BigDecimal lat = new BigDecimal(latitude);
        BigDecimal lon = new BigDecimal(longitude);
        Geolocation.validate(lat, lon);
        this.longitude = lon;
        this.latitude = lat;
    }

    public Geolocation(String center) {
        String longitudeString;
        String latitudeString;
        Matcher latitudeLongitude = LATITUDE_LONGITUDE.matcher(center);
        Matcher wellKnown = WELL_KNOWN_TEXT_POINT.matcher(center);
        if (latitudeLongitude.matches()) {
            latitudeString = latitudeLongitude.group(1);
            longitudeString = latitudeLongitude.group(3);
        } else if (wellKnown.matches()) {
            longitudeString = wellKnown.group(1);
            latitudeString = wellKnown.group(2);
        } else {
            throw new IllegalArgumentException("Geohash format is currently unsupported");
        }
        Geolocation.validate(new BigDecimal(latitudeString), new BigDecimal(longitudeString));
        this.longitude = new BigDecimal(longitudeString);
        this.latitude = new BigDecimal(latitudeString);
    }

    private static void validate(BigDecimal latitude, BigDecimal longitude) {
        if (latitude.compareTo(BigDecimal.valueOf(-90L)) < 0) {
            throw new IllegalArgumentException("Latitude cannot be less than -90. Received " + latitude);
        }
        if (latitude.compareTo(BigDecimal.valueOf(90L)) > 0) {
            throw new IllegalArgumentException("Latitude cannot be more than 90. Received " + latitude);
        }
        if (longitude.compareTo(BigDecimal.valueOf(-180L)) < 0) {
            throw new IllegalArgumentException("Longitude cannot be less than -180. Received " + longitude);
        }
        if (longitude.compareTo(BigDecimal.valueOf(180L)) > 0) {
            throw new IllegalArgumentException("Longitude cannot be more than 180. Received " + longitude);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Geolocation)) {
            return false;
        }
        Geolocation that = (Geolocation)o;
        return this.latitude.equals(that.latitude) && this.longitude.equals(that.longitude);
    }

    public int hashCode() {
        return Objects.hash(this.latitude, this.longitude);
    }

    public BigDecimal getLatitude() {
        return this.latitude;
    }

    public BigDecimal getLongitude() {
        return this.longitude;
    }

    public String toString() {
        return "Geolocation(latitude=" + this.getLatitude() + ", longitude=" + this.getLongitude() + ")";
    }

    public static enum Unit {
        MILLIMETERS("mm"),
        CENTIMETERS("cm"),
        METERS("m"),
        KILOMETERS("km"),
        INCHES("in"),
        FEET("ft"),
        YARDS("yd"),
        MILES("mi");

        @JsonValue
        private final String value;

        @JsonCreator
        public static Unit findByValue(String value) {
            return Arrays.stream(Unit.values()).filter(v -> v.value.equals(value)).findFirst().orElse(null);
        }

        public String getValue() {
            return this.value;
        }

        private Unit(String value) {
            this.value = value;
        }
    }
}

