/*
 * Decompiled with CFR 0.152.
 */
package co.elasticsearch.enterprisesearch.client.model.request.search.filter;

import co.elasticsearch.enterprisesearch.client.model.request.search.filter.FieldFilter;
import co.elasticsearch.enterprisesearch.client.model.request.search.filter.Filter;
import co.elasticsearch.enterprisesearch.client.model.request.search.range.DateRange;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.time.OffsetDateTime;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class DateRangeFilter
implements Filter,
FieldFilter {
    private final String name;
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss[.SS]XXX")
    private OffsetDateTime from;
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss[.SS]XXX")
    private OffsetDateTime to;

    public DateRangeFilter setRange(DateRange range) {
        this.from = range == null ? null : range.getFrom();
        this.to = range == null ? null : range.getTo();
        return this;
    }

    public DateRange getRange() {
        return this.from == null && this.to == null ? null : new DateRange(this.from, this.to);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DateRangeFilter)) {
            return false;
        }
        DateRangeFilter that = (DateRangeFilter)o;
        return this.name.equals(that.name) && Objects.equals(this.from, that.from) && Objects.equals(this.to, that.to);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.from, this.to);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public OffsetDateTime getFrom() {
        return this.from;
    }

    public OffsetDateTime getTo() {
        return this.to;
    }

    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss[.SS]XXX")
    public DateRangeFilter setFrom(OffsetDateTime from) {
        this.from = from;
        return this;
    }

    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss[.SS]XXX")
    public DateRangeFilter setTo(OffsetDateTime to) {
        this.to = to;
        return this;
    }

    public DateRangeFilter(String name) {
        this.name = name;
    }

    public String toString() {
        return "DateRangeFilter(name=" + this.getName() + ", from=" + this.getFrom() + ", to=" + this.getTo() + ")";
    }
}

