/*
 * Decompiled with CFR 0.152.
 */
package co.elasticsearch.enterprisesearch.client.model.request.search.range;

import co.elasticsearch.enterprisesearch.client.model.request.search.filter.DateValueFilter;
import co.elasticsearch.enterprisesearch.client.model.request.search.range.Range;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.time.OffsetDateTime;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonDeserialize
public class DateRange
implements Range<OffsetDateTime> {
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss[.SS]XXX")
    private OffsetDateTime from;
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss[.SS]XXX")
    private OffsetDateTime to;
    private String name;

    public DateRange() {
    }

    public DateRange(OffsetDateTime from, OffsetDateTime to) {
        this.from = from;
        this.to = to;
    }

    public DateRange(String from, String to) {
        if (from != null) {
            this.from = OffsetDateTime.parse(from, DateValueFilter.RFC_3339);
        }
        if (to != null) {
            this.to = OffsetDateTime.parse(to, DateValueFilter.RFC_3339);
        }
    }

    @Override
    public OffsetDateTime getFrom() {
        return this.from;
    }

    @Override
    public OffsetDateTime getTo() {
        return this.to;
    }

    public String getName() {
        return this.name;
    }

    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss[.SS]XXX")
    public DateRange setFrom(OffsetDateTime from) {
        this.from = from;
        return this;
    }

    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss[.SS]XXX")
    public DateRange setTo(OffsetDateTime to) {
        this.to = to;
        return this;
    }

    public DateRange setName(String name) {
        this.name = name;
        return this;
    }
}

