/*
 * Decompiled with CFR 0.152.
 */
package co.elasticsearch.enterprisesearch.client.model.response.search;

import co.elasticsearch.enterprisesearch.client.model.response.ErrorableResponse;
import co.elasticsearch.enterprisesearch.client.model.response.search.Meta;
import co.elasticsearch.enterprisesearch.client.model.response.search.ResponseDocument;
import co.elasticsearch.enterprisesearch.client.model.response.search.facet.DateRangeFacet;
import co.elasticsearch.enterprisesearch.client.model.response.search.facet.DateValueFacet;
import co.elasticsearch.enterprisesearch.client.model.response.search.facet.EmptyRangeFacet;
import co.elasticsearch.enterprisesearch.client.model.response.search.facet.EmptyValueFacet;
import co.elasticsearch.enterprisesearch.client.model.response.search.facet.Facet;
import co.elasticsearch.enterprisesearch.client.model.response.search.facet.GeolocationRangeFacet;
import co.elasticsearch.enterprisesearch.client.model.response.search.facet.NumberRangeFacet;
import co.elasticsearch.enterprisesearch.client.model.response.search.facet.NumberValueFacet;
import co.elasticsearch.enterprisesearch.client.model.response.search.facet.TextValueFacet;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class SearchApiResponse<T extends ResponseDocument>
implements Iterable<T>,
ErrorableResponse {
    private static final Logger log = LoggerFactory.getLogger(SearchApiResponse.class);
    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=Meta.class)
    private Meta meta = new Meta();
    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    private List<T> results = new ArrayList<T>();
    private List<String> errors = new ArrayList<String>();
    @JsonProperty(value="facets")
    @JsonFormat(without={JsonFormat.Feature.WRITE_SINGLE_ELEM_ARRAYS_UNWRAPPED})
    private Map<String, List<Facet>> facetMap = new LinkedHashMap<String, List<Facet>>();

    @JsonIgnore
    @JsonSerialize
    public List<Facet> getFacets() {
        return this.facetMap.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    public List<Facet> getFacetsByField(String fieldName) {
        return this.facetMap.getOrDefault(fieldName, Collections.emptyList());
    }

    public <F extends Facet> Optional<F> getFacetByName(String facetName, Class<F> facetType) {
        return this.facetMap.values().stream().flatMap(Collection::stream).filter(f -> facetName.equals(f.getName())).map(f -> SearchApiResponse.castFacet(f, facetType)).filter(Objects::nonNull).findFirst();
    }

    public <F extends Facet> Optional<F> getFacetByFieldAndName(String fieldName, String facetName, Class<F> facetType) {
        return this.getFacetsByField(fieldName).stream().filter(f -> facetName.equals(f.getName())).map(f -> SearchApiResponse.castFacet(f, facetType)).filter(Objects::nonNull).findFirst();
    }

    private static <F extends Facet> F castFacet(Facet f, Class<F> facetType) {
        if (f.getClass().equals(facetType)) {
            return (F)((Facet)facetType.cast(f));
        }
        if (f.getClass().equals(EmptyValueFacet.class)) {
            if (facetType.equals(TextValueFacet.class)) {
                return (F)new TextValueFacet().setName(f.getName());
            }
            if (facetType.equals(NumberValueFacet.class)) {
                return (F)new NumberValueFacet().setName(f.getName());
            }
            if (facetType.equals(DateValueFacet.class)) {
                return (F)new DateValueFacet().setName(f.getName());
            }
            log.warn("Requested Facet Type {} but was {}", facetType, f.getClass());
            return null;
        }
        if (f.getClass().equals(EmptyRangeFacet.class)) {
            if (facetType.equals(NumberRangeFacet.class)) {
                return (F)new NumberRangeFacet().setName(f.getName());
            }
            if (facetType.equals(DateRangeFacet.class)) {
                return (F)new DateRangeFacet().setName(f.getName());
            }
            if (facetType.equals(GeolocationRangeFacet.class)) {
                return (F)new GeolocationRangeFacet().setName(f.getName());
            }
            log.warn("Requested Facet Type {} but was {}", facetType, f.getClass());
            return null;
        }
        return null;
    }

    @Override
    @JsonIgnore
    @NotNull
    public Iterator<T> iterator() {
        return this.results.iterator();
    }

    @Override
    public void forEach(Consumer<? super T> action) {
        this.results.forEach(action);
    }

    @Override
    @JsonIgnore
    public Spliterator<T> spliterator() {
        return this.results.spliterator();
    }

    @JsonIgnore
    public boolean isWarning() {
        return !this.meta.getWarnings().isEmpty();
    }

    @JsonIgnore
    public boolean isAlert() {
        return !this.meta.getAlerts().isEmpty();
    }

    @Override
    @JsonIgnore
    public boolean isError() {
        return !this.errors.isEmpty();
    }

    public Meta getMeta() {
        return this.meta;
    }

    public List<T> getResults() {
        return this.results;
    }

    public List<String> getErrors() {
        return this.errors;
    }

    public SearchApiResponse<T> setMeta(Meta meta) {
        this.meta = meta;
        return this;
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public SearchApiResponse<T> setResults(List<T> results) {
        this.results = results;
        return this;
    }

    public SearchApiResponse<T> setErrors(List<String> errors) {
        this.errors = errors;
        return this;
    }

    @JsonProperty(value="facets")
    @JsonFormat(without={JsonFormat.Feature.WRITE_SINGLE_ELEM_ARRAYS_UNWRAPPED})
    public SearchApiResponse<T> setFacetMap(Map<String, List<Facet>> facetMap) {
        this.facetMap = facetMap;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SearchApiResponse)) {
            return false;
        }
        SearchApiResponse other = (SearchApiResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Meta this$meta = this.getMeta();
        Meta other$meta = other.getMeta();
        if (this$meta == null ? other$meta != null : !((Object)this$meta).equals(other$meta)) {
            return false;
        }
        List<T> this$results = this.getResults();
        List<T> other$results = other.getResults();
        if (this$results == null ? other$results != null : !((Object)this$results).equals(other$results)) {
            return false;
        }
        List<String> this$errors = this.getErrors();
        List<String> other$errors = other.getErrors();
        if (this$errors == null ? other$errors != null : !((Object)this$errors).equals(other$errors)) {
            return false;
        }
        Map<String, List<Facet>> this$facetMap = this.getFacetMap();
        Map<String, List<Facet>> other$facetMap = other.getFacetMap();
        return !(this$facetMap == null ? other$facetMap != null : !((Object)this$facetMap).equals(other$facetMap));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SearchApiResponse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Meta $meta = this.getMeta();
        result = result * 59 + ($meta == null ? 43 : ((Object)$meta).hashCode());
        List<T> $results = this.getResults();
        result = result * 59 + ($results == null ? 43 : ((Object)$results).hashCode());
        List<String> $errors = this.getErrors();
        result = result * 59 + ($errors == null ? 43 : ((Object)$errors).hashCode());
        Map<String, List<Facet>> $facetMap = this.getFacetMap();
        result = result * 59 + ($facetMap == null ? 43 : ((Object)$facetMap).hashCode());
        return result;
    }

    public String toString() {
        return "SearchApiResponse(meta=" + this.getMeta() + ", results=" + this.getResults() + ", errors=" + this.getErrors() + ", facetMap=" + this.getFacetMap() + ")";
    }

    Map<String, List<Facet>> getFacetMap() {
        return this.facetMap;
    }
}

