/*
 * Decompiled with CFR 0.152.
 */
package co.elasticsearch.enterprisesearch.client;

import co.elasticsearch.enterprisesearch.client.ClientUtils;
import co.elasticsearch.enterprisesearch.client.SearchApi;
import co.elasticsearch.enterprisesearch.client.model.request.search.MultiSearchRequest;
import co.elasticsearch.enterprisesearch.client.model.request.search.SearchRequest;
import co.elasticsearch.enterprisesearch.client.model.response.search.MultiSearchApiResponse;
import co.elasticsearch.enterprisesearch.client.model.response.search.ResponseDocument;
import co.elasticsearch.enterprisesearch.client.model.response.search.SearchApiResponse;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Objects;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SearchApiImpl<T extends ResponseDocument>
implements SearchApi<T> {
    private static final Logger log = LoggerFactory.getLogger(SearchApiImpl.class);
    private final ObjectMapper objectMapper;
    private final String baseUrl;
    private final OkHttpClient client;
    private final Class<T> resultType;

    @Override
    public SearchApiResponse<T> search(String engineName, SearchRequest request) {
        HttpUrl url = Objects.requireNonNull(HttpUrl.parse((String)(this.baseUrl + "/api/as/v1/engines/{engineName}/search"))).newBuilder().setPathSegment(4, engineName).build();
        Request okRequest = new Request.Builder().url(url).post(ClientUtils.marshalPayload(this.objectMapper, request)).build();
        JavaType type = this.objectMapper.getTypeFactory().constructParametricType(SearchApiResponse.class, new Class[]{this.resultType});
        return (SearchApiResponse)ClientUtils.marshalResponse(this.client, okRequest, this.objectMapper, type);
    }

    @Override
    public MultiSearchApiResponse<T> search(String engineName, MultiSearchRequest request) {
        HttpUrl url = Objects.requireNonNull(HttpUrl.parse((String)(this.baseUrl + "/api/as/v1/engines/{engineName}/search"))).newBuilder().setPathSegment(4, engineName).build();
        Request okRequest = new Request.Builder().url(url).post(ClientUtils.marshalPayload(this.objectMapper, request)).build();
        JavaType type = this.objectMapper.getTypeFactory().constructParametricType(SearchApiResponse.class, new Class[]{this.resultType});
        type = this.objectMapper.getTypeFactory().constructParametricType(MultiSearchApiResponse.class, new JavaType[]{type});
        return (MultiSearchApiResponse)ClientUtils.marshalResponse(this.client, okRequest, this.objectMapper, type);
    }

    public SearchApiImpl(ObjectMapper objectMapper, String baseUrl, OkHttpClient client, Class<T> resultType) {
        this.objectMapper = objectMapper;
        this.baseUrl = baseUrl;
        this.client = client;
        this.resultType = resultType;
    }
}

