/*
 * Decompiled with CFR 0.152.
 */
package co.elasticsearch.enterprisesearch.client.model;

import co.elasticsearch.enterprisesearch.client.model.Geolocation;
import co.elasticsearch.enterprisesearch.client.model.SortOrder;
import co.elasticsearch.enterprisesearch.client.model.SortSerializer;
import co.elasticsearch.enterprisesearch.client.model.request.search.GeolocationSort;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonKey;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonSerialize(using=SortSerializer.class)
public class Sort {
    private static final Logger log = LoggerFactory.getLogger(Sort.class);
    public static final String SCORE = "_score";
    @JsonKey
    private String name;
    @JsonValue
    private SortOrder direction;

    public Sort() {
    }

    public Sort(String field, @NonNull Order order) {
        if (order == null) {
            throw new NullPointerException("order is marked non-null but is null");
        }
        this.name = field;
        this.direction = order;
    }

    public Sort(String field, GeolocationSort location) {
        this.name = field;
        this.direction = location;
    }

    @JsonCreator
    static Sort createSort(ObjectNode node) {
        Map.Entry field = (Map.Entry)node.fields().next();
        if (((JsonNode)field.getValue()).getNodeType().equals((Object)JsonNodeType.STRING)) {
            return new Sort((String)field.getKey(), Order.fromValue(((JsonNode)field.getValue()).asText()));
        }
        JsonNode centerNode = ((JsonNode)field.getValue()).get("center");
        JsonNode modeNode = ((JsonNode)field.getValue()).get("mode");
        JsonNode orderNode = ((JsonNode)field.getValue()).get("order");
        GeolocationSort geoLocationSort = centerNode.isArray() ? new GeolocationSort(new Geolocation(centerNode.get(0).asText(), centerNode.get(1).asText())) : new GeolocationSort(new Geolocation(centerNode.asText()));
        geoLocationSort.setMode(GeolocationSort.Mode.fromValue(modeNode.textValue()));
        geoLocationSort.setOrder(Order.fromValue(orderNode.textValue()));
        return new Sort((String)field.getKey(), geoLocationSort);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Sort)) {
            return false;
        }
        Sort sort = (Sort)o;
        return this.name.equals(sort.name) && this.direction.equals(sort.direction);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.direction);
    }

    public String getName() {
        return this.name;
    }

    public SortOrder getDirection() {
        return this.direction;
    }

    public Sort setName(String name) {
        this.name = name;
        return this;
    }

    public Sort setDirection(SortOrder direction) {
        this.direction = direction;
        return this;
    }

    public static enum Order implements SortOrder
    {
        ASCENDING("asc"),
        DESCENDING("desc");

        @JsonValue
        private final String value;

        @JsonCreator
        public static Order fromValue(String value) {
            return Arrays.stream(Order.values()).filter(m -> m.value.equals(value)).findFirst().orElseThrow();
        }

        @Override
        public Order getOrder() {
            return this;
        }

        public String getValue() {
            return this.value;
        }

        private Order(String value) {
            this.value = value;
        }
    }
}

