/*
 * Decompiled with CFR 0.152.
 */
package co.elasticsearch.enterprisesearch.client.model.request.search;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import jakarta.validation.constraints.Max;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class Analytics {
    private Set<String> tags = new HashSet<String>();

    @JsonIgnore
    public Analytics addTag(@Max(value=64L) @Max(value=64L) String tag) {
        this.tags.add(tag);
        return this;
    }

    public Analytics withTags(String ... tags) {
        this.tags = new HashSet<String>(Arrays.asList(tags));
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Analytics analytics = (Analytics)o;
        return Objects.equals(this.tags, analytics.tags);
    }

    public int hashCode() {
        return Objects.hash(this.tags);
    }

    public Set<String> getTags() {
        return this.tags;
    }

    public Analytics setTags(Set<String> tags) {
        this.tags = tags;
        return this;
    }
}

