/*
 * Decompiled with CFR 0.152.
 */
package co.elasticsearch.enterprisesearch.client.model.request.search.boost;

import co.elasticsearch.enterprisesearch.client.model.DeserializationUtil;
import co.elasticsearch.enterprisesearch.client.model.Geolocation;
import co.elasticsearch.enterprisesearch.client.model.request.search.boost.Boost;
import co.elasticsearch.enterprisesearch.client.model.request.search.boost.DateValueBoost;
import co.elasticsearch.enterprisesearch.client.model.request.search.boost.FunctionalBoost;
import co.elasticsearch.enterprisesearch.client.model.request.search.boost.GeolocationProximityBoost;
import co.elasticsearch.enterprisesearch.client.model.request.search.boost.NumberProximityBoost;
import co.elasticsearch.enterprisesearch.client.model.request.search.boost.NumericValueBoost;
import co.elasticsearch.enterprisesearch.client.model.request.search.boost.RecencyBoost;
import co.elasticsearch.enterprisesearch.client.model.request.search.boost.TextValueBoost;
import co.elasticsearch.enterprisesearch.client.model.request.search.filter.DateValueFilter;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.node.NumericNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.OffsetDateTime;
import java.util.stream.Collectors;
import java.util.stream.Stream;

class BoostDeserializer
extends StdDeserializer<Boost> {
    protected BoostDeserializer() {
        super(Boost.class);
    }

    public Boost deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        TreeNode node = jsonParser.readValueAsTree();
        TreeNode typeNode = node.get("type");
        if (typeNode instanceof TextNode) {
            TextNode typeTextNode = (TextNode)typeNode;
            Boost.BoostType boostType = Boost.BoostType.findByValue(typeTextNode.textValue());
            if (Boost.BoostType.PROXIMITY.equals((Object)boostType)) {
                return this.deserializeProximityBoost(node, jsonParser);
            }
            if (Boost.BoostType.FUNCTIONAL.equals((Object)boostType)) {
                return new FunctionalBoost().setFactor(this.getFactor(node)).setFunction(this.getFunction(node)).setOperation(this.getOperation(node));
            }
            if (Boost.BoostType.VALUE.equals((Object)boostType)) {
                return this.deserializeValueBoost(node);
            }
        }
        return null;
    }

    private Boost deserializeProximityBoost(TreeNode node, JsonParser jsonParser) throws JsonProcessingException {
        TreeNode center = node.get("center");
        TreeNode factorNode = node.get("factor");
        TreeNode functionNode = node.get("function");
        BigDecimal factor = null;
        Boost.Function function = null;
        if (factorNode instanceof NumericNode) {
            NumericNode numericFactor = (NumericNode)factorNode;
            factor = new BigDecimal(numericFactor.asText());
        }
        if (functionNode instanceof TextNode) {
            TextNode functionText = (TextNode)functionNode;
            function = Boost.Function.findByValue(functionText.textValue());
        }
        if (center instanceof TextNode) {
            TextNode centerText = (TextNode)center;
            if ("now".equals(centerText.asText()) || DeserializationUtil.isDate(centerText)) {
                RecencyBoost recencyBoost = new RecencyBoost().setFactor(factor).setFunction(function);
                if ("now".equals(centerText.asText())) {
                    recencyBoost.setUseNow(true);
                } else {
                    recencyBoost.setCenter(OffsetDateTime.parse(centerText.asText(), DateValueFilter.RFC_3339));
                }
                return recencyBoost;
            }
            Geolocation geoCenter = (Geolocation)jsonParser.getCodec().treeToValue(center, Geolocation.class);
            return new GeolocationProximityBoost().setFactor(factor).setFunction(function).setCenter(geoCenter);
        }
        if (center instanceof NumericNode) {
            NumericNode centerNumber = (NumericNode)center;
            return new NumberProximityBoost().setFactor(factor).setFunction(function).setCenter(new BigDecimal(centerNumber.asText()));
        }
        return null;
    }

    private Boost deserializeValueBoost(TreeNode node) {
        TreeNode valueNode = node.get("value");
        JsonNode firstValue = DeserializationUtil.getFirstValue(valueNode);
        Stream<JsonNode> nodeStream = DeserializationUtil.getNodeStream(valueNode);
        if (firstValue instanceof TextNode) {
            if (DeserializationUtil.isDate((TextNode)firstValue)) {
                return new DateValueBoost().setFactor(this.getFactor(node)).setOperation(this.getOperation(node)).setValue(nodeStream.map(JsonNode::asText).map(dateVal -> OffsetDateTime.parse(dateVal, DateValueFilter.RFC_3339)).collect(Collectors.toList()));
            }
            return new TextValueBoost().setFactor(this.getFactor(node)).setOperation(this.getOperation(node)).setValue(nodeStream.map(JsonNode::asText).collect(Collectors.toList()));
        }
        if (firstValue instanceof NumericNode) {
            return new NumericValueBoost().setFactor(this.getFactor(node)).setOperation(this.getOperation(node)).setValue(nodeStream.map(numVal -> new BigDecimal(numVal.asText())).collect(Collectors.toList()));
        }
        return null;
    }

    private BigDecimal getFactor(TreeNode node) {
        TreeNode factorNode = node.get("factor");
        if (factorNode instanceof NumericNode) {
            NumericNode numericFactor = (NumericNode)factorNode;
            return new BigDecimal(numericFactor.asText());
        }
        return null;
    }

    private Boost.Function getFunction(TreeNode node) {
        TreeNode functionNode = node.get("function");
        if (functionNode instanceof TextNode) {
            TextNode functionText = (TextNode)functionNode;
            return Boost.Function.findByValue(functionText.textValue());
        }
        return null;
    }

    private Boost.Operation getOperation(TreeNode node) {
        TreeNode operationNode = node.get("operation");
        if (operationNode instanceof TextNode) {
            TextNode operationText = (TextNode)operationNode;
            return Boost.Operation.findByValue(operationText.textValue());
        }
        return null;
    }
}

