/*
 * Decompiled with CFR 0.152.
 */
package co.elasticsearch.enterprisesearch.client.model.request.search.filter;

import co.elasticsearch.enterprisesearch.client.model.DeserializationUtil;
import co.elasticsearch.enterprisesearch.client.model.GeolocationRange;
import co.elasticsearch.enterprisesearch.client.model.request.search.filter.BooleanFilter;
import co.elasticsearch.enterprisesearch.client.model.request.search.filter.DateRangeFilter;
import co.elasticsearch.enterprisesearch.client.model.request.search.filter.DateValueFilter;
import co.elasticsearch.enterprisesearch.client.model.request.search.filter.Filter;
import co.elasticsearch.enterprisesearch.client.model.request.search.filter.GeolocationFilter;
import co.elasticsearch.enterprisesearch.client.model.request.search.filter.NumberRangeFilter;
import co.elasticsearch.enterprisesearch.client.model.request.search.filter.NumberValueFilter;
import co.elasticsearch.enterprisesearch.client.model.request.search.filter.TextValueFilter;
import co.elasticsearch.enterprisesearch.client.model.request.search.range.DateRange;
import co.elasticsearch.enterprisesearch.client.model.request.search.range.NumberRange;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.NumericNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

class FilterDeserializer
extends StdDeserializer<Filter> {
    private static final Set<String> NESTED_KEYS = Set.of("all", "any", "none");

    protected FilterDeserializer() {
        super(Filter.class);
    }

    private static List<Filter> parseFilters(JsonParser jsonParser, ArrayNode filterValues) throws JsonProcessingException {
        if (filterValues == null) {
            return Collections.emptyList();
        }
        ArrayList<Filter> filters = new ArrayList<Filter>();
        for (JsonNode element : filterValues) {
            filters.add((Filter)jsonParser.getCodec().treeToValue((TreeNode)element, Filter.class));
        }
        return filters;
    }

    private static BooleanFilter deserializeNestedFilter(JsonParser jsonParser, TreeNode node) throws JsonProcessingException {
        BooleanFilter filter = new BooleanFilter();
        ArrayNode allNode = (ArrayNode)node.get("all");
        filter.setAll(FilterDeserializer.parseFilters(jsonParser, allNode));
        ArrayNode anyNode = (ArrayNode)node.get("any");
        filter.setAny(FilterDeserializer.parseFilters(jsonParser, anyNode));
        ArrayNode noneNode = (ArrayNode)node.get("none");
        filter.setNone(FilterDeserializer.parseFilters(jsonParser, noneNode));
        return filter;
    }

    private static boolean isNestedFilter(TreeNode node) {
        Iterator fieldNames = node.fieldNames();
        if (!fieldNames.hasNext()) {
            return true;
        }
        while (fieldNames.hasNext()) {
            String fieldName = (String)fieldNames.next();
            if (!NESTED_KEYS.contains(fieldName)) continue;
            return true;
        }
        return false;
    }

    public Filter deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        TreeNode node = jsonParser.readValueAsTree();
        if (FilterDeserializer.isNestedFilter(node)) {
            return FilterDeserializer.deserializeNestedFilter(jsonParser, node);
        }
        Iterator fieldNames = node.fieldNames();
        String filterName = (String)fieldNames.next();
        TreeNode filterNode = node.get(filterName);
        TreeNode to = filterNode.get("to");
        TreeNode from = filterNode.get("from");
        if (filterNode.get("center") != null) {
            return new GeolocationFilter(filterName).setRange((GeolocationRange)jsonParser.getCodec().treeToValue(filterNode, GeolocationRange.class));
        }
        if (to instanceof NumericNode || from instanceof NumericNode) {
            return new NumberRangeFilter(filterName).setRange((NumberRange)jsonParser.getCodec().treeToValue(filterNode, NumberRange.class));
        }
        if (to instanceof TextNode || from instanceof TextNode) {
            return new DateRangeFilter(filterName).setRange((DateRange)jsonParser.getCodec().treeToValue(filterNode, DateRange.class));
        }
        JsonNode firstValue = DeserializationUtil.getFirstValue(filterNode);
        Stream<JsonNode> nodeStream = DeserializationUtil.getNodeStream(filterNode);
        if (firstValue instanceof NumericNode) {
            return new NumberValueFilter(filterName).setValues(nodeStream.map(JsonNode::asText).map(BigDecimal::new).collect(Collectors.toList()));
        }
        if (DeserializationUtil.isDate((TextNode)firstValue)) {
            return new DateValueFilter(filterName).setValues(nodeStream.map(JsonNode::asText).map(dateString -> OffsetDateTime.parse(dateString, DateValueFilter.RFC_3339)).collect(Collectors.toList()));
        }
        return new TextValueFilter(filterName).setValues(nodeStream.map(JsonNode::asText).collect(Collectors.toList()));
    }
}

