/*
 * Decompiled with CFR 0.152.
 */
package io.cui.tools.collect;

import io.cui.tools.collect.MoreCollections;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Stream;
import lombok.Generated;

public final class CollectionLiterals {
    public static <E> List<E> mutableList() {
        return new ArrayList();
    }

    @SafeVarargs
    public static <E> List<E> mutableList(E ... elements) {
        if (MoreCollections.isEmpty(elements)) {
            return new ArrayList();
        }
        return new ArrayList<E>(Arrays.asList(elements));
    }

    public static <E> List<E> mutableList(E element) {
        ArrayList<E> list = new ArrayList<E>();
        list.add(element);
        return list;
    }

    public static <E> List<E> mutableList(Iterable<? extends E> elements) {
        ArrayList list = new ArrayList();
        if (MoreCollections.isEmpty(elements)) {
            return list;
        }
        elements.forEach(list::add);
        return list;
    }

    public static <E> List<E> mutableList(Collection<? extends E> elements) {
        if (MoreCollections.isEmpty(elements)) {
            return new ArrayList();
        }
        return new ArrayList<E>(elements);
    }

    public static <E> List<E> mutableList(Stream<? extends E> elements) {
        ArrayList list = new ArrayList();
        if (MoreCollections.isEmpty(elements)) {
            return list;
        }
        elements.forEach(list::add);
        return list;
    }

    public static <E> List<E> mutableList(Iterator<? extends E> elements) {
        ArrayList<E> list = new ArrayList<E>();
        if (MoreCollections.isEmpty(elements)) {
            return list;
        }
        while (elements.hasNext()) {
            list.add(elements.next());
        }
        return list;
    }

    public static <E> List<E> immutableList() {
        return Collections.emptyList();
    }

    @SafeVarargs
    public static <E> List<E> immutableList(E ... elements) {
        if (MoreCollections.isEmpty(elements)) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(CollectionLiterals.mutableList(elements));
    }

    public static <E> List<E> immutableList(E element) {
        if (null == element) {
            return Collections.emptyList();
        }
        return Collections.singletonList(element);
    }

    public static <E> List<E> immutableList(Iterable<? extends E> elements) {
        if (MoreCollections.isEmpty(elements)) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(CollectionLiterals.mutableList(elements));
    }

    public static <E> List<E> immutableList(Collection<? extends E> elements) {
        if (MoreCollections.isEmpty(elements)) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(CollectionLiterals.mutableList(elements));
    }

    public static <E> List<E> immutableList(Stream<? extends E> elements) {
        if (MoreCollections.isEmpty(elements)) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(CollectionLiterals.mutableList(elements));
    }

    public static <E> List<E> immutableList(Iterator<? extends E> elements) {
        if (MoreCollections.isEmpty(elements)) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(CollectionLiterals.mutableList(elements));
    }

    public static <E> Set<E> mutableSet() {
        return new HashSet();
    }

    public static <E> Set<E> mutableSet(E element) {
        HashSet<E> set = new HashSet<E>();
        if (null == element) {
            return set;
        }
        set.add(element);
        return set;
    }

    @SafeVarargs
    public static <E> Set<E> mutableSet(E ... elements) {
        if (MoreCollections.isEmpty(elements)) {
            return new HashSet();
        }
        return new HashSet<E>(Arrays.asList(elements));
    }

    public static <E> Set<E> mutableSet(Iterable<? extends E> elements) {
        HashSet set = new HashSet();
        if (MoreCollections.isEmpty(elements)) {
            return set;
        }
        elements.forEach(set::add);
        return set;
    }

    public static <E> Set<E> mutableSet(Collection<? extends E> elements) {
        if (MoreCollections.isEmpty(elements)) {
            return new HashSet();
        }
        return new HashSet<E>(elements);
    }

    public static <E> Set<E> mutableSet(Iterator<? extends E> elements) {
        HashSet<E> set = new HashSet<E>();
        if (MoreCollections.isEmpty(elements)) {
            return set;
        }
        while (elements.hasNext()) {
            set.add(elements.next());
        }
        return set;
    }

    public static <E> Set<E> mutableSet(Stream<? extends E> elements) {
        HashSet set = new HashSet();
        if (MoreCollections.isEmpty(elements)) {
            return set;
        }
        elements.forEach(set::add);
        return set;
    }

    public static <E> Set<E> immutableSet() {
        return Collections.emptySet();
    }

    public static <E> Set<E> immutableSet(E element) {
        if (null == element) {
            return Collections.emptySet();
        }
        return Collections.singleton(element);
    }

    @SafeVarargs
    public static <E> Set<E> immutableSet(E ... elements) {
        if (MoreCollections.isEmpty(elements)) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(CollectionLiterals.mutableSet(elements));
    }

    public static <E> Set<E> immutableSet(Iterable<? extends E> elements) {
        if (MoreCollections.isEmpty(elements)) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(CollectionLiterals.mutableSet(elements));
    }

    public static <E> Set<E> immutableSet(Iterator<? extends E> elements) {
        if (MoreCollections.isEmpty(elements)) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(CollectionLiterals.mutableSet(elements));
    }

    public static <E> Set<E> immutableSet(Stream<? extends E> elements) {
        if (MoreCollections.isEmpty(elements)) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(CollectionLiterals.mutableSet(elements));
    }

    public static <E> SortedSet<E> mutableSortedSet() {
        return new TreeSet();
    }

    public static <E> SortedSet<E> mutableSortedSet(E element) {
        TreeSet<E> set = new TreeSet<E>();
        if (null == element) {
            return set;
        }
        set.add(element);
        return set;
    }

    @SafeVarargs
    public static <E> SortedSet<E> mutableSortedSet(E ... elements) {
        TreeSet<E> set = new TreeSet<E>();
        if (MoreCollections.isEmpty(elements)) {
            return set;
        }
        set.addAll(Arrays.asList(elements));
        return set;
    }

    public static <E> SortedSet<E> mutableSortedSet(Iterable<? extends E> elements) {
        TreeSet set = new TreeSet();
        if (null == elements) {
            return set;
        }
        elements.forEach(set::add);
        return set;
    }

    public static <E> SortedSet<E> mutableSortedSet(Iterator<? extends E> elements) {
        TreeSet<E> set = new TreeSet<E>();
        if (null == elements) {
            return set;
        }
        while (elements.hasNext()) {
            set.add(elements.next());
        }
        return set;
    }

    public static <E> SortedSet<E> mutableSortedSet(Stream<? extends E> elements) {
        TreeSet set = new TreeSet();
        if (null == elements) {
            return set;
        }
        elements.forEach(set::add);
        return set;
    }

    public static <E> SortedSet<E> immutableSortedSet() {
        return Collections.emptySortedSet();
    }

    public static <E> SortedSet<E> immutableSortedSet(E element) {
        if (null == element) {
            return Collections.emptySortedSet();
        }
        return Collections.unmodifiableSortedSet(CollectionLiterals.mutableSortedSet(element));
    }

    @SafeVarargs
    public static <E> SortedSet<E> immutableSortedSet(E ... elements) {
        return Collections.unmodifiableSortedSet(CollectionLiterals.mutableSortedSet(elements));
    }

    public static <E> SortedSet<E> immutableSortedSet(Iterable<? extends E> elements) {
        return Collections.unmodifiableSortedSet(CollectionLiterals.mutableSortedSet(elements));
    }

    public static <E> SortedSet<E> immutableSortedSet(Iterator<? extends E> elements) {
        return Collections.unmodifiableSortedSet(CollectionLiterals.mutableSortedSet(elements));
    }

    public static <E> SortedSet<E> immutableSortedSet(Stream<? extends E> elements) {
        return Collections.unmodifiableSortedSet(CollectionLiterals.mutableSortedSet(elements));
    }

    public static <K, V> Map<K, V> mutableMap() {
        return new HashMap();
    }

    public static <K, V> Map<K, V> mutableMap(K k, V v) {
        HashMap<K, V> map = new HashMap<K, V>();
        map.put(k, v);
        return map;
    }

    public static <K, V> Map<K, V> mutableMap(K k1, V v1, K k2, V v2) {
        HashMap<K, V> map = new HashMap<K, V>();
        map.put(k1, v1);
        map.put(k2, v2);
        return map;
    }

    public static <K, V> Map<K, V> mutableMap(K k1, V v1, K k2, V v2, K k3, V v3) {
        HashMap<K, V> map = new HashMap<K, V>();
        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        return map;
    }

    public static <K, V> Map<K, V> mutableMap(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4) {
        HashMap<K, V> map = new HashMap<K, V>();
        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        return map;
    }

    public static <K, V> Map<K, V> immutableMap() {
        return Collections.emptyMap();
    }

    public static <K, V> Map<K, V> immutableMap(Map<K, V> source) {
        return Collections.unmodifiableMap(source);
    }

    public static <K, V> Map<K, V> immutableMap(Stream<Map.Entry<K, V>> elements) {
        Map map = CollectionLiterals.mutableMap();
        elements.forEach(entry -> map.put(entry.getKey(), entry.getValue()));
        return Collections.unmodifiableMap(map);
    }

    public static <K, V> Map<K, V> immutableMap(K k, V v) {
        Map<K, V> map = CollectionLiterals.mutableMap();
        map.put(k, v);
        return Collections.unmodifiableMap(map);
    }

    public static <K, V> Map<K, V> immutableMap(K k1, V v1, K k2, V v2) {
        Map<K, V> map = CollectionLiterals.mutableMap();
        map.put(k1, v1);
        map.put(k2, v2);
        return Collections.unmodifiableMap(map);
    }

    public static <K, V> Map<K, V> immutableMap(K k1, V v1, K k2, V v2, K k3, V v3) {
        Map<K, V> map = CollectionLiterals.mutableMap();
        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        return Collections.unmodifiableMap(map);
    }

    public static <K, V> Map<K, V> immutableMap(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4) {
        Map<K, V> map = CollectionLiterals.mutableMap();
        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        return Collections.unmodifiableMap(map);
    }

    @Generated
    private CollectionLiterals() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

