/*
 * Decompiled with CFR 0.152.
 */
package io.cui.tools.collect;

import io.cui.tools.collect.CollectionLiterals;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;

public final class MapBuilder<K, V> {
    private final Map<K, V> collector;

    public MapBuilder() {
        this(new HashMap());
    }

    public MapBuilder(Map<K, V> collector) {
        this.collector = Objects.requireNonNull(collector);
    }

    public int size() {
        return this.collector.size();
    }

    public boolean isEmpty() {
        return this.collector.isEmpty();
    }

    public boolean containsKey(Object key) {
        return this.collector.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this.collector.containsValue(value);
    }

    public MapBuilder<K, V> put(K key, V value) {
        this.collector.put(key, value);
        return this;
    }

    public MapBuilder<K, V> putIfNotNull(K key, V value) {
        if (null != value) {
            this.collector.put(key, value);
        }
        return this;
    }

    public MapBuilder<K, V> put(Map.Entry<? extends K, ? extends V> entry) {
        this.collector.put(entry.getKey(), entry.getValue());
        return this;
    }

    public MapBuilder<K, V> remove(Object key) {
        this.collector.remove(key);
        return this;
    }

    public MapBuilder<K, V> putAll(Map<? extends K, ? extends V> map) {
        this.collector.putAll(map);
        return this;
    }

    public MapBuilder<K, V> clear() {
        this.collector.clear();
        return this;
    }

    public Map<K, V> toMutableMap() {
        return new HashMap<K, V>(this.collector);
    }

    public Map<K, V> toImmutableMap() {
        return Collections.unmodifiableMap(this.collector);
    }

    public static <K, V> MapBuilder<K, V> copyFrom(Map<K, V> original) {
        return new MapBuilder<K, V>(new HashMap<K, V>(original));
    }

    public static <K, V> MapBuilder<K, V> from(K k1, V v1) {
        return new MapBuilder<K, V>(CollectionLiterals.mutableMap(k1, v1));
    }

    public static <K, V> MapBuilder<K, V> from(K k1, V v1, K k2, V v2) {
        return new MapBuilder<K, V>(CollectionLiterals.mutableMap(k1, v1, k2, v2));
    }

    public static <K, V> MapBuilder<K, V> from(K k1, V v1, K k2, V v2, K k3, V v3) {
        return new MapBuilder<K, V>(CollectionLiterals.mutableMap(k1, v1, k2, v2, k3, v3));
    }

    public static <K, V> MapBuilder<K, V> from(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4) {
        return new MapBuilder<K, V>(CollectionLiterals.mutableMap(k1, v1, k2, v2, k3, v3, k4, v4));
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MapBuilder)) {
            return false;
        }
        MapBuilder other = (MapBuilder)o;
        Map<K, V> this$collector = this.collector;
        Map<K, V> other$collector = other.collector;
        return !(this$collector == null ? other$collector != null : !((Object)this$collector).equals(other$collector));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<K, V> $collector = this.collector;
        result = result * 59 + ($collector == null ? 43 : ((Object)$collector).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "MapBuilder(collector=" + this.collector + ")";
    }
}

