/*
 * Decompiled with CFR 0.152.
 */
package io.cui.tools.collect;

import io.cui.tools.base.Preconditions;
import io.cui.tools.collect.MapDiffenceImpl;
import io.cui.tools.collect.MapDifference;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.stream.Stream;
import lombok.Generated;

public final class MoreCollections {
    public static boolean isEmpty(Object ... elements) {
        return null == elements || 0 == elements.length;
    }

    public static boolean isEmpty(Iterable<?> elements) {
        return null == elements || MoreCollections.isEmpty(elements.iterator());
    }

    public static boolean isEmpty(Collection<?> elements) {
        return null == elements || elements.isEmpty();
    }

    public static boolean isEmpty(Map<?, ?> map) {
        return null == map || map.isEmpty();
    }

    public static boolean isEmpty(Iterator<?> elements) {
        return null == elements || !elements.hasNext();
    }

    @SafeVarargs
    public static <T> T[] requireNotEmpty(T ... elements) {
        Preconditions.checkArgument(!MoreCollections.isEmpty(elements));
        return elements;
    }

    public static <T> Collection<T> requireNotEmpty(Collection<T> elements) {
        Preconditions.checkArgument(!MoreCollections.isEmpty(elements));
        return elements;
    }

    public static <T> Collection<T> requireNotEmpty(Collection<T> elements, String message) {
        Preconditions.checkArgument(!MoreCollections.isEmpty(elements), message);
        return elements;
    }

    public static <K, V> Map<K, V> requireNotEmpty(Map<K, V> elements) {
        Preconditions.checkArgument(!MoreCollections.isEmpty(elements));
        return elements;
    }

    public static <K, V> Map<K, V> requireNotEmpty(Map<K, V> elements, String message) {
        Preconditions.checkArgument(!MoreCollections.isEmpty(elements), message);
        return elements;
    }

    public static <T> Iterable<T> requireNotEmpty(Iterable<T> elements) {
        Preconditions.checkArgument(!MoreCollections.isEmpty(elements));
        return elements;
    }

    public static <T> Iterable<T> requireNotEmpty(Iterable<T> elements, String message) {
        Preconditions.checkArgument(!MoreCollections.isEmpty(elements), message);
        return elements;
    }

    public static <T> Iterator<T> requireNotEmpty(Iterator<T> elements) {
        Preconditions.checkArgument(!MoreCollections.isEmpty(elements));
        return elements;
    }

    public static <T> Iterator<T> requireNotEmpty(Iterator<T> elements, String message) {
        Preconditions.checkArgument(!MoreCollections.isEmpty(elements), message);
        return elements;
    }

    public static <T> Stream<T> requireNotEmpty(Stream<T> elements) {
        Preconditions.checkArgument(!MoreCollections.isEmpty(elements));
        return elements;
    }

    public static <T> Stream<T> requireNotEmpty(Stream<T> elements, String message) {
        Preconditions.checkArgument(!MoreCollections.isEmpty(elements), message);
        return elements;
    }

    public static boolean isEmpty(Stream<?> elements) {
        return null == elements;
    }

    public static boolean containsKey(Map<?, ?> map, Object ... keys) {
        if (MoreCollections.isEmpty(map) || MoreCollections.isEmpty(keys)) {
            return false;
        }
        for (Object key : keys) {
            if (!map.containsKey(key)) continue;
            return true;
        }
        return false;
    }

    public static <K, V> MapDifference<K, V> difference(Map<? extends K, ? extends V> left, Map<? extends K, ? extends V> right) {
        return MapDiffenceImpl.from(left, right);
    }

    @Generated
    private MoreCollections() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

