/*
 * Decompiled with CFR 0.152.
 */
package io.cui.tools.collect;

import io.cui.tools.collect.MoreCollections;
import io.cui.tools.collect.PartialCollection;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import lombok.Generated;

public class PartialArrayList<T extends Serializable>
extends ArrayList<T>
implements PartialCollection<T> {
    private static final long serialVersionUID = -7548645400982124555L;
    private final boolean moreAvailable;

    public PartialArrayList(Collection<T> list, boolean moreAvailable) {
        super(list);
        this.moreAvailable = moreAvailable;
    }

    public static <T extends Serializable> PartialArrayList<T> emptyList() {
        return new PartialArrayList(Collections.emptyList(), false);
    }

    public static <T extends Serializable> PartialArrayList<T> of(List<T> full, int limit) {
        if (MoreCollections.isEmpty(full)) {
            return PartialArrayList.emptyList();
        }
        int actualSize = full.size();
        if (actualSize <= limit) {
            return new PartialArrayList<T>(full, false);
        }
        return new PartialArrayList<T>(full.subList(0, limit), true);
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PartialArrayList)) {
            return false;
        }
        PartialArrayList other = (PartialArrayList)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        return this.isMoreAvailable() == other.isMoreAvailable();
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PartialArrayList;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isMoreAvailable() ? 79 : 97);
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "PartialArrayList(super=" + super.toString() + ", moreAvailable=" + this.isMoreAvailable() + ")";
    }

    @Override
    @Generated
    public boolean isMoreAvailable() {
        return this.moreAvailable;
    }
}

