/*
 * Decompiled with CFR 0.152.
 */
package io.cui.tools.formatting;

import io.cui.tools.collect.MoreCollections;
import io.cui.tools.string.MoreStrings;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;

public class SimpleFormatter
implements Serializable {
    private static final long serialVersionUID = -4761082365099064435L;
    private final String separator;
    private final ValueHandling handling;

    public String formatParentheses(String ... values) {
        return this.format(this.cleanUp(values));
    }

    public String format(String ... values) {
        return this.getJoined(this.cleanUp(values));
    }

    private List<String> cleanUp(String ... values) {
        ArrayList<String> result = new ArrayList<String>(0);
        if (null != values) {
            for (String item : values) {
                String value = MoreStrings.emptyToNull(item);
                if (null == value) {
                    if (!ValueHandling.FORMAT_IF_ALL_AVAILABLE.equals((Object)this.handling)) continue;
                    result.clear();
                    break;
                }
                result.add(value);
            }
        }
        return result;
    }

    private String getJoined(List<String> values) {
        if (MoreCollections.isEmpty(values)) {
            return null;
        }
        List filtered = values.stream().filter(element -> !MoreCollections.isEmpty(element)).collect(Collectors.toList());
        if (MoreCollections.isEmpty(filtered)) {
            return null;
        }
        return String.join((CharSequence)this.separator, filtered);
    }

    private String format(List<String> values) {
        String joined = this.getJoined(values);
        if (null != joined) {
            return String.format("(%s)", joined);
        }
        return null;
    }

    public static SimpleFormatterBuilder builder() {
        return new SimpleFormatterBuilder();
    }

    @Generated
    public SimpleFormatter(String separator, ValueHandling handling) {
        this.separator = separator;
        this.handling = handling;
    }

    @Generated
    public String getSeparator() {
        return this.separator;
    }

    @Generated
    public ValueHandling getHandling() {
        return this.handling;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SimpleFormatter)) {
            return false;
        }
        SimpleFormatter other = (SimpleFormatter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$separator = this.getSeparator();
        String other$separator = other.getSeparator();
        if (this$separator == null ? other$separator != null : !this$separator.equals(other$separator)) {
            return false;
        }
        ValueHandling this$handling = this.getHandling();
        ValueHandling other$handling = other.getHandling();
        return !(this$handling == null ? other$handling != null : !((Object)((Object)this$handling)).equals((Object)other$handling));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SimpleFormatter;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $separator = this.getSeparator();
        result = result * 59 + ($separator == null ? 43 : $separator.hashCode());
        ValueHandling $handling = this.getHandling();
        result = result * 59 + ($handling == null ? 43 : ((Object)((Object)$handling)).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "SimpleFormatter(separator=" + this.getSeparator() + ", handling=" + this.getHandling() + ")";
    }

    public static class SimpleFormatterBuilder
    implements Serializable {
        private static final long serialVersionUID = 6414005370772800008L;

        public BuilderWithStrategy skipResultIfAnyValueIsMissing() {
            return new BuilderWithStrategy(ValueHandling.FORMAT_IF_ALL_AVAILABLE);
        }

        public BuilderWithStrategy ignoreMissingValues() {
            return new BuilderWithStrategy(ValueHandling.FORMAT_IF_ANY_AVAILABLE);
        }

        @Generated
        public String toString() {
            return "SimpleFormatter.SimpleFormatterBuilder()";
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SimpleFormatterBuilder)) {
                return false;
            }
            SimpleFormatterBuilder other = (SimpleFormatterBuilder)o;
            return other.canEqual(this);
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof SimpleFormatterBuilder;
        }

        @Generated
        public int hashCode() {
            boolean result = true;
            return 1;
        }

        public static class BuilderWithStrategy
        implements Serializable {
            private static final long serialVersionUID = -1987354973684803562L;
            private final ValueHandling valueHandlingStrategy;

            protected BuilderWithStrategy(ValueHandling strategy) {
                this.valueHandlingStrategy = strategy;
            }

            public SimpleFormatter separatesBy(@NonNull String separator) {
                if (separator == null) {
                    throw new NullPointerException("separator is marked non-null but is null");
                }
                return new SimpleFormatter(separator, this.valueHandlingStrategy);
            }

            @Generated
            public String toString() {
                return "SimpleFormatter.SimpleFormatterBuilder.BuilderWithStrategy(valueHandlingStrategy=" + this.valueHandlingStrategy + ")";
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof BuilderWithStrategy)) {
                    return false;
                }
                BuilderWithStrategy other = (BuilderWithStrategy)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                ValueHandling this$valueHandlingStrategy = this.valueHandlingStrategy;
                ValueHandling other$valueHandlingStrategy = other.valueHandlingStrategy;
                return !(this$valueHandlingStrategy == null ? other$valueHandlingStrategy != null : !((Object)((Object)this$valueHandlingStrategy)).equals((Object)other$valueHandlingStrategy));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof BuilderWithStrategy;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                ValueHandling $valueHandlingStrategy = this.valueHandlingStrategy;
                result = result * 59 + ($valueHandlingStrategy == null ? 43 : ((Object)((Object)$valueHandlingStrategy)).hashCode());
                return result;
            }
        }
    }

    public static enum ValueHandling {
        FORMAT_IF_ANY_AVAILABLE,
        FORMAT_IF_ALL_AVAILABLE;

    }
}

