/*
 * Decompiled with CFR 0.152.
 */
package io.cui.tools.formatting.template;

import io.cui.tools.base.Preconditions;
import io.cui.tools.formatting.template.FormatterSupport;
import io.cui.tools.formatting.template.TemplateFormatter;
import io.cui.tools.formatting.template.lexer.Lexer;
import io.cui.tools.formatting.template.lexer.LexerBuilder;
import io.cui.tools.formatting.template.token.Token;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import lombok.Generated;

public final class TemplateFormatterImpl<T extends FormatterSupport>
implements TemplateFormatter<T> {
    @Generated
    private final Object $lock = new Object[0];
    private static final long serialVersionUID = -6297959581838201331L;
    private final String template;
    private ArrayList<Token> parsedTokens;
    private Lexer<T> lexer;
    private final boolean strict;

    private TemplateFormatterImpl(String template, boolean strict) {
        this.template = template;
        this.strict = strict;
    }

    TemplateFormatterImpl<T> scanBy(Lexer<T> lexerInstance) {
        this.lexer = Objects.requireNonNull(lexerInstance, "Parser must not be null");
        this.parsedTokens = null;
        return this;
    }

    @Override
    public String format(T reference) {
        Objects.requireNonNull(reference, "Reference must not be null");
        List<Token> tokenList = this.getParsedTokens();
        StringBuilder buffer = new StringBuilder(0);
        for (int index = 0; index < tokenList.size(); ++index) {
            Token token = tokenList.get(index);
            if (token.isStringToken()) {
                if (!this.lookUpLastTokenHasValue(tokenList, reference, index) || !this.lookUpNextTokenHasValue(tokenList, reference, index)) continue;
                buffer.append(token.substituteAttribute((FormatterSupport)reference));
                continue;
            }
            buffer.append(token.substituteAttribute((FormatterSupport)reference));
        }
        return buffer.toString();
    }

    private boolean lookUpNextTokenHasValue(List<Token> tokenList, T reference, int currentTokenIndex) {
        for (int nextTokenIndex = currentTokenIndex + 1; nextTokenIndex < tokenList.size(); ++nextTokenIndex) {
            String value;
            Token token = tokenList.get(nextTokenIndex);
            if (token.isStringToken() || (value = token.substituteAttribute((FormatterSupport)reference)).isEmpty()) continue;
            return true;
        }
        return false;
    }

    private boolean lookUpLastTokenHasValue(List<Token> tokenList, T reference, int currentTokenIndex) {
        boolean result = false;
        int lastTokenIndex = currentTokenIndex - 1;
        if (lastTokenIndex >= 0) {
            String value = tokenList.get(lastTokenIndex).substituteAttribute((FormatterSupport)reference);
            result = !value.isEmpty();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Token> getParsedTokens() {
        Object object = this.$lock;
        synchronized (object) {
            if (null == this.parsedTokens) {
                Preconditions.checkState(null != this.lexer, "Parser must be initialized before.");
                this.parsedTokens = new ArrayList<Token>(this.lexer.scan(this.template));
            }
            return this.parsedTokens;
        }
    }

    public static <F extends FormatterSupport> TemplateFormatter<F> createFormatter(String template, Class<F> sourceType) {
        return TemplateBuilder.useTemplate(template).forType(sourceType);
    }

    public static <F extends FormatterSupport> TemplateFormatter<F> createFormatter(String template, F source) {
        return TemplateBuilder.useTemplate(template).forSource(source);
    }

    public static <F extends FormatterSupport> TemplateFormatter<F> createFormatter(String template, Lexer<F> lexer) {
        return TemplateBuilder.useTemplate(template).scanBy(lexer);
    }

    public static <F extends FormatterSupport> TemplateFormatter<F> createFormatter(String template, Class<F> sourceType, boolean strict) {
        return TemplateBuilder.useTemplate(template).strict(strict).forType(sourceType);
    }

    public static <F extends FormatterSupport> TemplateFormatter<F> createFormatter(String template, F source, boolean strict) {
        return TemplateBuilder.useTemplate(template).strict(strict).forSource(source);
    }

    public static <F extends FormatterSupport> TemplateFormatter<F> createFormatter(String template, Lexer<F> lexer, boolean strict) {
        return TemplateBuilder.useTemplate(template).strict(strict).scanBy(lexer);
    }

    public static TemplateBuilder builder() {
        return new TemplateBuilder();
    }

    @Generated
    public String toString() {
        return "TemplateFormatterImpl(template=" + this.template + ", parsedTokens=" + this.getParsedTokens() + ", lexer=" + this.lexer + ", strict=" + this.strict + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TemplateFormatterImpl)) {
            return false;
        }
        TemplateFormatterImpl other = (TemplateFormatterImpl)o;
        if (this.strict != other.strict) {
            return false;
        }
        String this$template = this.template;
        String other$template = other.template;
        if (this$template == null ? other$template != null : !this$template.equals(other$template)) {
            return false;
        }
        List<Token> this$parsedTokens = this.getParsedTokens();
        List<Token> other$parsedTokens = other.getParsedTokens();
        if (this$parsedTokens == null ? other$parsedTokens != null : !((Object)this$parsedTokens).equals(other$parsedTokens)) {
            return false;
        }
        Lexer<T> this$lexer = this.lexer;
        Lexer<T> other$lexer = other.lexer;
        return !(this$lexer == null ? other$lexer != null : !((Object)this$lexer).equals(other$lexer));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.strict ? 79 : 97);
        String $template = this.template;
        result = result * 59 + ($template == null ? 43 : $template.hashCode());
        List<Token> $parsedTokens = this.getParsedTokens();
        result = result * 59 + ($parsedTokens == null ? 43 : ((Object)$parsedTokens).hashCode());
        Lexer<T> $lexer = this.lexer;
        result = result * 59 + ($lexer == null ? 43 : ((Object)$lexer).hashCode());
        return result;
    }

    public static final class TemplateBuilder {
        private TemplateBuilder() {
        }

        static FormatterBuilder useTemplate(String template) {
            return new FormatterBuilder(template);
        }

        static final class FormatterBuilder {
            private final String template;
            private boolean strict;

            FormatterBuilder(String templateInput) {
                this.template = templateInput;
            }

            public FormatterBuilder strict(boolean strict) {
                this.strict = strict;
                return this;
            }

            public <F extends FormatterSupport> TemplateFormatter<F> scanBy(Lexer<F> lexer) {
                return new TemplateFormatterImpl<F>(this.template, this.strict).scanBy(lexer);
            }

            public <F extends FormatterSupport> TemplateFormatter<F> forSource(F source) {
                Lexer<F> lexer = LexerBuilder.useSimpleElWithSquaredBrackets().strict(this.strict).build(source);
                return this.scanBy(lexer);
            }

            public <F extends FormatterSupport> TemplateFormatter<F> forType(Class<F> classType) {
                Lexer<F> lexer = LexerBuilder.useSimpleElWithSquaredBrackets().strict(this.strict).build(classType);
                return this.scanBy(lexer);
            }
        }
    }
}

