/*
 * Decompiled with CFR 0.152.
 */
package io.cui.tools.formatting.template;

import io.cui.tools.formatting.template.FormatterSupport;
import io.cui.tools.formatting.template.TemplateFormatter;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import lombok.Generated;

public class TemplateManager<T extends FormatterSupport> {
    private final TemplateFormatter<T> defaultFormatter;
    private final Map<Locale, TemplateFormatter<T>> localeSpecificMap;

    public String format(T targetToFormat, Locale locale) {
        if (this.localeSpecificMap.containsKey(locale)) {
            return this.localeSpecificMap.get(locale).format(targetToFormat);
        }
        return this.defaultFormatter.format(targetToFormat);
    }

    @Generated
    private TemplateManager(TemplateFormatter<T> defaultFormatter, Map<Locale, TemplateFormatter<T>> localeSpecificMap) {
        this.defaultFormatter = defaultFormatter;
        this.localeSpecificMap = localeSpecificMap;
    }

    public static class TemplateManagerBuilder<B extends FormatterSupport> {
        private final Map<Locale, TemplateFormatter<B>> map = new HashMap<Locale, TemplateFormatter<B>>();
        private TemplateFormatter<B> defFormatter;

        public TemplateManagerBuilder<B> with(Map<Locale, TemplateFormatter<B>> mapValue) {
            if (null != mapValue) {
                this.map.putAll(mapValue);
            }
            return this;
        }

        public TemplateManagerBuilder<B> with(Locale locale, TemplateFormatter<B> formatter) {
            this.map.put(locale, formatter);
            return this;
        }

        public TemplateManagerBuilder<B> useAsDefault(TemplateFormatter<B> formatter) {
            this.defFormatter = formatter;
            return this;
        }

        public TemplateManager<B> build() {
            return new TemplateManager<B>(this.defFormatter, this.map);
        }
    }
}

