/*
 * Decompiled with CFR 0.152.
 */
package io.cui.tools.formatting.template;

import io.cui.tools.formatting.template.FormatterSupport;
import io.cui.tools.formatting.template.lexer.Lexer;
import io.cui.tools.formatting.template.lexer.LexerBuilder;
import java.io.Serializable;
import java.util.Objects;
import lombok.Generated;

public class Validator<F extends FormatterSupport>
implements Serializable {
    private static final long serialVersionUID = 8358892211840118282L;
    private final Lexer<F> lexer;

    Validator(Lexer<F> lexer) {
        this.lexer = Objects.requireNonNull(lexer);
    }

    public void validate(String template) {
        Objects.requireNonNull(template, "Template must not be null.");
        this.lexer.validateTemplate(template);
    }

    public static <E extends FormatterSupport> ValidatorBuilder<E> builder() {
        return new ValidatorBuilder();
    }

    public static <E extends FormatterSupport> void validateTemplate(String template, E source) {
        new ValidatorBuilder<E>().forSource(source).validate(template);
    }

    public static <E extends FormatterSupport> void validateTemplate(String template, Class<E> source) {
        new ValidatorBuilder<E>().forType(source).validate(template);
    }

    public static <E extends FormatterSupport> void validateTemplate(String template, Lexer<E> lexer) {
        new ValidatorBuilder<E>().withLexer(lexer).validate(template);
    }

    public static final class ValidatorBuilder<E extends FormatterSupport> {
        private Lexer<E> lexer;

        public Validator<E> forType(Class<E> source) {
            if (null == this.lexer) {
                this.lexer = this.useSimpleElWithSquaredBrackets((E)source);
            }
            return new Validator<E>(this.lexer);
        }

        public Validator<E> withLexer(Lexer<E> lexerInstance) {
            return new Validator<E>(lexerInstance);
        }

        public Validator<E> forSource(E source) {
            if (null == this.lexer) {
                this.lexer = this.useSimpleElWithSquaredBrackets(source);
            }
            return new Validator<E>(this.lexer);
        }

        private Lexer<E> useSimpleElWithSquaredBrackets(Class<E> source) {
            return LexerBuilder.useSimpleElWithSquaredBrackets().build(source);
        }

        private Lexer<E> useSimpleElWithSquaredBrackets(E source) {
            return LexerBuilder.useSimpleElWithSquaredBrackets().build(source);
        }

        @Generated
        public ValidatorBuilder() {
        }
    }
}

