/*
 * Decompiled with CFR 0.152.
 */
package io.cui.tools.io;

import io.cui.tools.base.Preconditions;
import io.cui.tools.io.FileReaderWriter;
import io.cui.tools.io.FileTypePrefix;
import io.cui.tools.io.MorePaths;
import io.cui.tools.io.StructuredFilename;
import io.cui.tools.logging.CuiLogger;
import io.cui.tools.string.MoreStrings;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import lombok.Generated;

public class FileSystemLoader
implements FileReaderWriter {
    private static final long serialVersionUID = -1278929108857440808L;
    private static final CuiLogger LOG = new CuiLogger(FileSystemLoader.class);
    private final String normalizedPathName;
    private final boolean readable;
    private final boolean writable;
    private final StructuredFilename fileName;

    public FileSystemLoader(String pathName) {
        Objects.requireNonNull(pathName);
        this.normalizedPathName = FileSystemLoader.checkPathName(pathName);
        Preconditions.checkArgument(!MoreStrings.isEmpty(this.normalizedPathName), "'%s' can not be normalized", pathName);
        Path path = this.getPath();
        this.readable = MorePaths.checkReadablePath(path, false, true);
        this.writable = MorePaths.checkAccessiblePath(path, false, false);
        this.fileName = new StructuredFilename(path.toAbsolutePath().getFileName().toString());
    }

    public FileSystemLoader(Path path) {
        this(Objects.requireNonNull(path).toFile().getAbsolutePath());
    }

    public Path getPath() {
        return Paths.get(this.normalizedPathName, new String[0]);
    }

    @Override
    public InputStream inputStream() throws IOException {
        if (!this.isReadable()) {
            throw new IllegalStateException("'" + this.normalizedPathName + "' is not readable");
        }
        return Files.newInputStream(this.getPath(), new OpenOption[0]);
    }

    public static String checkPathName(String pathName) {
        MoreStrings.requireNotEmpty(pathName, "pathName");
        if (pathName.startsWith(FileTypePrefix.CLASSPATH.getPrefix())) {
            throw new IllegalArgumentException("Invalid path name, must start not start with " + FileTypePrefix.CLASSPATH + " but was: " + pathName);
        }
        Object newPathName = pathName;
        if (pathName.startsWith(FileTypePrefix.FILE.getPrefix())) {
            newPathName = FileTypePrefix.FILE.removePrefix(pathName);
        } else if (pathName.startsWith(FileTypePrefix.EXTERNAL.getPrefix())) {
            try {
                newPathName = new File(".").getCanonicalPath() + FileTypePrefix.EXTERNAL.removePrefix(pathName);
                LOG.debug("Loading config file from external path: {}", newPathName);
            }
            catch (IOException e) {
                LOG.error("Retrieving the current dir failed: ", e);
            }
        }
        if (MoreStrings.isEmpty((CharSequence)newPathName)) {
            throw new IllegalArgumentException("Filename " + pathName + " is invalid");
        }
        return MorePaths.getRealPathSafely((String)newPathName, new String[0]).toString();
    }

    @Override
    public boolean isFilesystemLoader() {
        return true;
    }

    @Override
    public URL getURL() {
        try {
            return this.getPath().toUri().toURL();
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public OutputStream outputStream() throws IOException {
        if (!this.isWritable()) {
            throw new IllegalStateException(this.normalizedPathName + " is not writable");
        }
        return Files.newOutputStream(this.getPath(), new OpenOption[0]);
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FileSystemLoader)) {
            return false;
        }
        FileSystemLoader other = (FileSystemLoader)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$normalizedPathName = this.normalizedPathName;
        String other$normalizedPathName = other.normalizedPathName;
        return !(this$normalizedPathName == null ? other$normalizedPathName != null : !this$normalizedPathName.equals(other$normalizedPathName));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FileSystemLoader;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $normalizedPathName = this.normalizedPathName;
        result = result * 59 + ($normalizedPathName == null ? 43 : $normalizedPathName.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "FileSystemLoader(normalizedPathName=" + this.normalizedPathName + ", readable=" + this.isReadable() + ", writable=" + this.isWritable() + ", fileName=" + this.getFileName() + ")";
    }

    @Override
    @Generated
    public boolean isReadable() {
        return this.readable;
    }

    @Override
    @Generated
    public boolean isWritable() {
        return this.writable;
    }

    @Override
    @Generated
    public StructuredFilename getFileName() {
        return this.fileName;
    }
}

