/*
 * Decompiled with CFR 0.152.
 */
package io.cui.tools.io;

import io.cui.tools.string.Splitter;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.List;
import lombok.Generated;

public class StructuredFilename
implements Serializable {
    private static final long serialVersionUID = 7473756881958645393L;
    private final String originalName;
    private final String namePart;
    private final String suffix;

    public StructuredFilename(String filename) {
        this.originalName = filename;
        List<String> list = Splitter.on(".").omitEmptyStrings().splitToList(filename);
        switch (list.size()) {
            case 0: {
                this.namePart = filename;
                this.suffix = null;
                break;
            }
            case 1: {
                this.namePart = filename;
                this.suffix = null;
                break;
            }
            case 2: {
                this.namePart = list.get(0);
                this.suffix = list.get(1);
                break;
            }
            default: {
                this.suffix = list.get(list.size() - 1);
                this.namePart = String.join((CharSequence)".", list.subList(0, list.size() - 1));
            }
        }
    }

    public StructuredFilename(Path path) {
        this(path.getName(path.getNameCount() - 1).toString());
    }

    public StructuredFilename(File file) {
        this(file.toPath());
    }

    public String getAppendedName(String nameSuffix) {
        StringBuilder builder = new StringBuilder(this.namePart);
        if (null != nameSuffix) {
            builder.append(nameSuffix);
        }
        if (null != this.suffix) {
            builder.append('.');
            builder.append(this.suffix);
        }
        return builder.toString();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StructuredFilename)) {
            return false;
        }
        StructuredFilename other = (StructuredFilename)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$originalName = this.getOriginalName();
        String other$originalName = other.getOriginalName();
        if (this$originalName == null ? other$originalName != null : !this$originalName.equals(other$originalName)) {
            return false;
        }
        String this$namePart = this.getNamePart();
        String other$namePart = other.getNamePart();
        if (this$namePart == null ? other$namePart != null : !this$namePart.equals(other$namePart)) {
            return false;
        }
        String this$suffix = this.getSuffix();
        String other$suffix = other.getSuffix();
        return !(this$suffix == null ? other$suffix != null : !this$suffix.equals(other$suffix));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof StructuredFilename;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $originalName = this.getOriginalName();
        result = result * 59 + ($originalName == null ? 43 : $originalName.hashCode());
        String $namePart = this.getNamePart();
        result = result * 59 + ($namePart == null ? 43 : $namePart.hashCode());
        String $suffix = this.getSuffix();
        result = result * 59 + ($suffix == null ? 43 : $suffix.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "StructuredFilename(originalName=" + this.getOriginalName() + ", namePart=" + this.getNamePart() + ", suffix=" + this.getSuffix() + ")";
    }

    @Generated
    public String getOriginalName() {
        return this.originalName;
    }

    @Generated
    public String getNamePart() {
        return this.namePart;
    }

    @Generated
    public String getSuffix() {
        return this.suffix;
    }
}

