/*
 * Decompiled with CFR 0.152.
 */
package io.cui.tools.lang;

import io.cui.tools.string.MoreStrings;
import java.util.Locale;
import lombok.Generated;

public final class LocaleUtils {
    private static final String INVALID_LOCALE_FORMAT = "Invalid locale format: ";

    public static Locale toLocale(String str) {
        if (str == null) {
            return null;
        }
        if (str.isEmpty()) {
            return new Locale("", "");
        }
        if (str.contains("#")) {
            throw new IllegalArgumentException(INVALID_LOCALE_FORMAT + str);
        }
        int len = str.length();
        if (len < 2) {
            throw new IllegalArgumentException(INVALID_LOCALE_FORMAT + str);
        }
        char ch0 = str.charAt(0);
        if (ch0 == '_') {
            if (len < 3) {
                throw new IllegalArgumentException(INVALID_LOCALE_FORMAT + str);
            }
            char ch1 = str.charAt(1);
            char ch2 = str.charAt(2);
            if (!Character.isUpperCase(ch1) || !Character.isUpperCase(ch2)) {
                throw new IllegalArgumentException(INVALID_LOCALE_FORMAT + str);
            }
            if (len == 3) {
                return new Locale("", str.substring(1, 3));
            }
            if (len < 5 || str.charAt(3) != '_') {
                throw new IllegalArgumentException(INVALID_LOCALE_FORMAT + str);
            }
            return new Locale("", str.substring(1, 3), str.substring(4));
        }
        return LocaleUtils.parseLocale(str);
    }

    private static Locale parseLocale(String str) {
        if (LocaleUtils.isISO639LanguageCode(str)) {
            return new Locale(str);
        }
        String[] segments = str.split("_", -1);
        String language = segments[0];
        if (segments.length == 2) {
            String country = segments[1];
            if (LocaleUtils.isISO639LanguageCode(language) && LocaleUtils.isISO3166CountryCode(country) || LocaleUtils.isNumericAreaCode(country)) {
                return new Locale(language, country);
            }
        } else if (segments.length == 3) {
            String country = segments[1];
            String variant = segments[2];
            if (LocaleUtils.isISO639LanguageCode(language) && (country.isEmpty() || LocaleUtils.isISO3166CountryCode(country) || LocaleUtils.isNumericAreaCode(country)) && !variant.isEmpty()) {
                return new Locale(language, country, variant);
            }
        }
        throw new IllegalArgumentException(INVALID_LOCALE_FORMAT + str);
    }

    private static boolean isISO639LanguageCode(String str) {
        return MoreStrings.isAllLowerCase(str) && (str.length() == 2 || str.length() == 3);
    }

    private static boolean isISO3166CountryCode(String str) {
        return MoreStrings.isAllUpperCase(str) && str.length() == 2;
    }

    private static boolean isNumericAreaCode(String str) {
        return MoreStrings.isNumeric(str) && str.length() == 3;
    }

    @Generated
    private LocaleUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

