/*
 * Decompiled with CFR 0.152.
 */
package io.cui.tools.logging;

import io.cui.tools.collect.CollectionLiterals;
import io.cui.tools.logging.CuiLogger;
import io.cui.tools.logging.CuiLoggerFactory;
import io.cui.tools.reflect.MoreReflection;
import io.cui.tools.string.MoreStrings;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import lombok.Generated;
import lombok.NonNull;

public enum LogLevel {
    TRACE(Level.FINER),
    DEBUG(Level.FINE),
    INFO(Level.INFO),
    WARN(Level.WARNING),
    ERROR(Level.SEVERE),
    OFF(Level.OFF);

    private final Level juliLevel;

    boolean isEnabled(Logger logger) {
        return logger.isLoggable(this.getJuliLevel());
    }

    void handleActualLog(Logger logger, String message, Throwable throwable) {
        if (!this.isEnabled(logger)) {
            return;
        }
        this.doLog(logger, message, throwable);
    }

    public static LogLevel from(@NonNull Level juliLevel) {
        if (juliLevel == null) {
            throw new NullPointerException("juliLevel is marked non-null but is null");
        }
        List<LogLevel[]> sortedCuiLevels = CollectionLiterals.mutableList(LogLevel.values());
        sortedCuiLevels.sort(Comparator.comparing(logLevel -> logLevel.getJuliLevel().intValue()));
        sortedCuiLevels.sort(Comparator.reverseOrder());
        int juliIntLevel = juliLevel.intValue();
        for (LogLevel logLevel2 : sortedCuiLevels) {
            int cuiIntLevel = logLevel2.getJuliLevel().intValue();
            if (cuiIntLevel > juliIntLevel) continue;
            return logLevel2;
        }
        return TRACE;
    }

    private void doLog(Logger logger, String message, Throwable throwable) {
        Optional<StackTraceElement> caller = MoreReflection.findCallerElement(throwable, CuiLoggerFactory.MARKER_CLASS_NAMES);
        if (caller.isPresent()) {
            logger.logp(this.getJuliLevel(), caller.get().getClassName(), caller.get().getMethodName(), message, throwable);
        } else {
            logger.log(this.getJuliLevel(), message, throwable);
        }
    }

    void log(Logger logger, String template, Object ... parameter) {
        if (this.isEnabled(logger)) {
            String replacedTemplate = CuiLogger.SLF4J_PATTERN.matcher(MoreStrings.nullToEmpty(template)).replaceAll("%s");
            this.doLog(logger, MoreStrings.lenientFormat(replacedTemplate, parameter), null);
        }
    }

    void log(Logger logger, Supplier<String> message, Throwable throwable) {
        if (this.isEnabled(logger)) {
            this.doLog(logger, message.get(), throwable);
        }
    }

    void log(Logger logger, Throwable throwable, String template, Object ... parameter) {
        if (this.isEnabled(logger)) {
            String replacedTemplate = CuiLogger.SLF4J_PATTERN.matcher(MoreStrings.nullToEmpty(template)).replaceAll("%s");
            this.doLog(logger, MoreStrings.lenientFormat(replacedTemplate, parameter), throwable);
        }
    }

    @Generated
    private LogLevel(Level juliLevel) {
        this.juliLevel = juliLevel;
    }

    @Generated
    Level getJuliLevel() {
        return this.juliLevel;
    }
}

