/*
 * Decompiled with CFR 0.152.
 */
package io.cui.tools.net;

import io.cui.tools.logging.CuiLogger;
import io.cui.tools.string.MoreStrings;
import io.cui.tools.string.Splitter;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import lombok.Generated;

public final class UrlHelper {
    private static final CuiLogger LOGGER = new CuiLogger(UrlHelper.class);

    public static String addTrailingSlashToUrl(String url) {
        if (MoreStrings.isEmpty(url) || url.endsWith("/")) {
            return url;
        }
        return url + "/";
    }

    public static String removeTrailingSlashesFromUrl(String url) {
        if (MoreStrings.isEmpty(url) || !url.endsWith("/")) {
            return url;
        }
        return UrlHelper.removeTrailingSlashesFromUrl(url.substring(0, url.length() - 1));
    }

    public static String addPrecedingSlashToPath(String path) {
        if (MoreStrings.isEmpty(path)) {
            return "/";
        }
        if (path.startsWith("/")) {
            return path;
        }
        return "/" + path;
    }

    public static String removePrecedingSlashFromPath(String path) {
        if (MoreStrings.isEmpty(path) || !path.startsWith("/")) {
            return path;
        }
        return UrlHelper.removePrecedingSlashFromPath(path.substring(1));
    }

    public static List<String> splitPath(String pathString) {
        if (MoreStrings.isEmpty(pathString)) {
            return Collections.emptyList();
        }
        return Splitter.on("/").trimResults().omitEmptyStrings().splitToList(pathString);
    }

    public static Optional<URI> tryParseUri(String uri) {
        if (!MoreStrings.isEmpty(uri)) {
            try {
                return Optional.of(new URI(uri));
            }
            catch (URISyntaxException e) {
                LOGGER.trace(e, "Invalid URI", new Object[0]);
            }
        }
        return Optional.empty();
    }

    public static boolean isValidUri(String uri) {
        if (!MoreStrings.isEmpty(uri)) {
            try {
                new URI(uri);
            }
            catch (URISyntaxException e) {
                return false;
            }
        }
        return true;
    }

    @Generated
    private UrlHelper() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

