/*
 * Decompiled with CFR 0.152.
 */
package io.cui.tools.net;

import io.cui.tools.collect.CollectionBuilder;
import io.cui.tools.collect.CollectionLiterals;
import io.cui.tools.collect.MoreCollections;
import io.cui.tools.logging.CuiLogger;
import io.cui.tools.net.ParameterFilter;
import io.cui.tools.string.Joiner;
import io.cui.tools.string.MoreStrings;
import io.cui.tools.string.Splitter;
import java.io.Serializable;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;

public class UrlParameter
implements Serializable,
Comparable<UrlParameter> {
    private static final CuiLogger log = new CuiLogger(UrlParameter.class);
    public static final UrlParameter FACES_REDIRECT = new UrlParameter("faces-redirect", "true");
    public static final UrlParameter INCLUDE_VIEW_PARAMETER = new UrlParameter("includeViewParams", "true");
    private static final long serialVersionUID = 634175928228707534L;
    private final String name;
    private final String value;

    public UrlParameter(String name, String value) {
        this(name, value, true);
    }

    public UrlParameter(String name, String value, boolean encode) {
        MoreStrings.requireNotEmptyTrimmed(name, "Parameter name must not be empty");
        if (encode) {
            this.name = URLEncoder.encode(name, StandardCharsets.UTF_8);
            this.value = MoreStrings.isEmpty(value) ? null : URLEncoder.encode(value, StandardCharsets.UTF_8);
        } else {
            this.name = name;
            this.value = value;
        }
    }

    public boolean isEmpty() {
        return null == this.value;
    }

    public static String createParameterString(UrlParameter ... parameters) {
        return UrlParameter.createParameterString(false, parameters);
    }

    public static String createParameterString(boolean encode, UrlParameter ... parameters) {
        StringBuilder builder = new StringBuilder();
        if (null != parameters && parameters.length > 0 && null != parameters[0]) {
            builder.append('?').append(parameters[0].createNameValueString(encode));
            if (parameters.length > 1) {
                for (int i = 1; i < parameters.length; ++i) {
                    builder.append('&').append(parameters[i].createNameValueString(encode));
                }
            }
        }
        return builder.toString();
    }

    public static final List<UrlParameter> getUrlParameterFromMap(Map<String, List<String>> map, ParameterFilter parameterFilter, boolean encode) {
        if (MoreCollections.isEmpty(map)) {
            return Collections.emptyList();
        }
        ArrayList<UrlParameter> extracted = new ArrayList<UrlParameter>();
        for (Map.Entry<String, List<String>> entry : map.entrySet()) {
            String value = null;
            if (!MoreCollections.isEmpty((Collection)entry.getValue())) {
                value = entry.getValue().get(0);
            }
            String key = entry.getKey();
            if (null != parameterFilter && parameterFilter.isExcluded(key)) continue;
            try {
                extracted.add(new UrlParameter(key, value, encode));
            }
            catch (IllegalArgumentException e) {
                log.debug("Unable to read url parameter due to missing parameter name", e.getMessage());
            }
        }
        extracted.sort(Comparator.comparing(UrlParameter::getName));
        return extracted;
    }

    public static List<UrlParameter> filterParameter(List<UrlParameter> toBeFiltered, ParameterFilter parameterFilter) {
        if (toBeFiltered == null || toBeFiltered.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<UrlParameter> filtered = new ArrayList<UrlParameter>();
        for (UrlParameter parameter : toBeFiltered) {
            String key = parameter.getName();
            if (null != parameterFilter && parameterFilter.isExcluded(key)) continue;
            filtered.add(parameter);
        }
        return filtered;
    }

    public static final Map<String, List<String>> createParameterMap(List<UrlParameter> urlParameters) {
        HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        if (null != urlParameters && !urlParameters.isEmpty()) {
            for (UrlParameter urlParameter : urlParameters) {
                result.put(urlParameter.getName(), CollectionLiterals.immutableList(urlParameter.getValue()));
            }
        }
        return result;
    }

    public static List<UrlParameter> fromQueryString(String queryString) {
        log.trace("Parsing Query String %s", queryString);
        if (MoreStrings.isEmpty(queryString)) {
            return Collections.emptyList();
        }
        String cleaned = queryString.trim();
        if (cleaned.startsWith("?")) {
            cleaned = cleaned.substring(1);
        }
        if (MoreStrings.isEmpty(cleaned)) {
            log.debug("Given String solely consists of '?' symbol, ignoring");
            return Collections.emptyList();
        }
        List<String> elements = Splitter.on("&").omitEmptyStrings().splitToList(cleaned);
        CollectionBuilder<UrlParameter> builder = new CollectionBuilder<UrlParameter>();
        for (String element : elements) {
            if (element.contains("=")) {
                List<String> splitted = Splitter.on("=").omitEmptyStrings().splitToList(element);
                switch (splitted.size()) {
                    case 0: {
                        log.debug("Unable to parse queryString '%s' correctly, unable to extract key-value-pair for element '%s'", queryString, element);
                        break;
                    }
                    case 1: {
                        builder.add(UrlParameter.createDecoded(splitted.get(0), null));
                        break;
                    }
                    case 2: {
                        builder.add(UrlParameter.createDecoded(splitted.get(0), splitted.get(1)));
                        break;
                    }
                    default: {
                        log.debug("Unable to parse queryString '%s' correctly, multiple '=' symbols found at unexpected locations", queryString);
                        break;
                    }
                }
                continue;
            }
            builder.add(UrlParameter.createDecoded(element, null));
        }
        return builder.toImmutableList();
    }

    private static UrlParameter createDecoded(String name, String value) {
        Objects.requireNonNull(name);
        String decodedKey = URLDecoder.decode(name, StandardCharsets.UTF_8);
        String decodedValue = null;
        if (null != value) {
            decodedValue = URLDecoder.decode(value, StandardCharsets.UTF_8);
        }
        return new UrlParameter(decodedKey, decodedValue, false);
    }

    public String createNameValueString() {
        return this.createNameValueString(false);
    }

    public String createNameValueString(boolean encode) {
        if (encode) {
            return new UrlParameter(this.name, this.value).createNameValueString();
        }
        return Joiner.on('=').useForNull("").join(this.name, this.value);
    }

    @Override
    public int compareTo(UrlParameter compareTo) {
        return this.getName().compareTo(compareTo.getName());
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UrlParameter)) {
            return false;
        }
        UrlParameter other = (UrlParameter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$value = this.getValue();
        String other$value = other.getValue();
        return !(this$value == null ? other$value != null : !this$value.equals(other$value));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof UrlParameter;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "UrlParameter(name=" + this.getName() + ", value=" + this.getValue() + ")";
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getValue() {
        return this.value;
    }
}

