/*
 * Decompiled with CFR 0.152.
 */
package io.cui.tools.property;

import io.cui.tools.base.Preconditions;
import io.cui.tools.collect.CollectionLiterals;
import io.cui.tools.logging.CuiLogger;
import io.cui.tools.property.PropertyMemberInfo;
import io.cui.tools.property.PropertyReadWrite;
import io.cui.tools.property.PropertyUtil;
import io.cui.tools.reflect.MoreReflection;
import io.cui.tools.string.MoreStrings;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import lombok.NonNull;

public final class PropertyHolder {
    private static final String UNABLE_TO_LOAD_PROPERTY_DESCRIPTOR = "Unable to load property-descriptor for attribute '%s' on type '%s'";
    private static final CuiLogger log = new CuiLogger(PropertyHolder.class);
    @NonNull
    private final String name;
    @NonNull
    private final Class<?> type;
    @NonNull
    private final PropertyMemberInfo memberInfo;
    @NonNull
    private final PropertyReadWrite readWrite;
    private final Method readMethod;
    private final Method writeMethod;

    public Object readFrom(Object bean) {
        log.debug("Reading property '%s' from %s", this.name, bean);
        Objects.requireNonNull(bean);
        Preconditions.checkState(this.readWrite.isReadable(), "Property '%s' on bean '%s' can not be read", this.name, bean);
        if (null != this.readMethod) {
            try {
                return this.readMethod.invoke(bean, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                throw new IllegalStateException(MoreStrings.lenientFormat("Unable to read property '%s' from beanType '%s'.", this.name, bean.getClass()), e);
            }
        }
        return PropertyUtil.readProperty(bean, this.name);
    }

    public Object writeTo(Object bean, Object propertyValue) {
        log.debug("Writing %s to property '%s' on %s", propertyValue, this.name, bean);
        Objects.requireNonNull(bean);
        Preconditions.checkState(this.readWrite.isWriteable(), "Property '%s' on bean '%s' can not be written", this.name, bean);
        if (null != this.writeMethod) {
            try {
                Object result = this.writeMethod.invoke(bean, propertyValue);
                return Objects.requireNonNullElse(result, bean);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                throw new IllegalStateException(MoreStrings.lenientFormat("Unable to write property '%s' to beanType '%s'. Needed property-type '%s'", this.name, bean.getClass()), e);
            }
        }
        return PropertyUtil.writeProperty(bean, this.name, propertyValue);
    }

    public static Optional<PropertyHolder> from(Class<?> beanType, String attributeName) {
        Objects.requireNonNull(beanType);
        MoreStrings.requireNotEmptyTrimmed(attributeName);
        try {
            BeanInfo info = Introspector.getBeanInfo(beanType);
            Optional<PropertyDescriptor> descriptor = CollectionLiterals.mutableList(info.getPropertyDescriptors()).stream().filter(desc -> attributeName.equalsIgnoreCase(desc.getName())).findFirst();
            if (!descriptor.isPresent()) {
                log.debug(UNABLE_TO_LOAD_PROPERTY_DESCRIPTOR, attributeName, beanType);
                return PropertyHolder.buildByReflection(beanType, attributeName);
            }
            return PropertyHolder.doBuild(descriptor.get(), beanType, attributeName);
        }
        catch (IntrospectionException e) {
            throw new IllegalArgumentException(MoreStrings.lenientFormat(UNABLE_TO_LOAD_PROPERTY_DESCRIPTOR, attributeName, beanType), e);
        }
    }

    private static Optional<PropertyHolder> doBuild(PropertyDescriptor propertyDescriptor, Class<?> type, String attributeName) {
        PropertyHolderBuilder builder = PropertyHolder.builder();
        builder.name(attributeName);
        builder.readWrite(PropertyReadWrite.fromPropertyDescriptor(propertyDescriptor, type, attributeName));
        builder.readMethod(propertyDescriptor.getReadMethod());
        builder.writeMethod(propertyDescriptor.getWriteMethod());
        builder.memberInfo(PropertyMemberInfo.resolveForBean(type, attributeName));
        builder.type(propertyDescriptor.getPropertyType());
        return Optional.of(builder.build());
    }

    static Optional<PropertyHolder> buildByReflection(Class<?> beanType, String attributeName) {
        log.trace("Trying reflection for determining attribute '%s' on type '%s'", attributeName, beanType);
        Optional<Field> field = MoreReflection.accessField(beanType, attributeName);
        if (!field.isPresent()) {
            return Optional.empty();
        }
        PropertyHolderBuilder builder = PropertyHolder.builder();
        builder.name(attributeName);
        builder.readWrite(PropertyReadWrite.resolveForBean(beanType, attributeName));
        builder.memberInfo(PropertyMemberInfo.resolveForBean(beanType, attributeName));
        builder.type(PropertyUtil.resolvePropertyType(beanType, attributeName).orElse(Object.class));
        return Optional.of(builder.build());
    }

    @Generated
    PropertyHolder(@NonNull String name, @NonNull Class<?> type, @NonNull PropertyMemberInfo memberInfo, @NonNull PropertyReadWrite readWrite, Method readMethod, Method writeMethod) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (memberInfo == null) {
            throw new NullPointerException("memberInfo is marked non-null but is null");
        }
        if (readWrite == null) {
            throw new NullPointerException("readWrite is marked non-null but is null");
        }
        this.name = name;
        this.type = type;
        this.memberInfo = memberInfo;
        this.readWrite = readWrite;
        this.readMethod = readMethod;
        this.writeMethod = writeMethod;
    }

    @Generated
    public static PropertyHolderBuilder builder() {
        return new PropertyHolderBuilder();
    }

    @NonNull
    @Generated
    public String getName() {
        return this.name;
    }

    @NonNull
    @Generated
    public Class<?> getType() {
        return this.type;
    }

    @NonNull
    @Generated
    public PropertyMemberInfo getMemberInfo() {
        return this.memberInfo;
    }

    @NonNull
    @Generated
    public PropertyReadWrite getReadWrite() {
        return this.readWrite;
    }

    @Generated
    public Method getReadMethod() {
        return this.readMethod;
    }

    @Generated
    public Method getWriteMethod() {
        return this.writeMethod;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PropertyHolder)) {
            return false;
        }
        PropertyHolder other = (PropertyHolder)o;
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Class<?> this$type = this.getType();
        Class<?> other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        PropertyMemberInfo this$memberInfo = this.getMemberInfo();
        PropertyMemberInfo other$memberInfo = other.getMemberInfo();
        if (this$memberInfo == null ? other$memberInfo != null : !((Object)((Object)this$memberInfo)).equals((Object)other$memberInfo)) {
            return false;
        }
        PropertyReadWrite this$readWrite = this.getReadWrite();
        PropertyReadWrite other$readWrite = other.getReadWrite();
        if (this$readWrite == null ? other$readWrite != null : !((Object)((Object)this$readWrite)).equals((Object)other$readWrite)) {
            return false;
        }
        Method this$readMethod = this.getReadMethod();
        Method other$readMethod = other.getReadMethod();
        if (this$readMethod == null ? other$readMethod != null : !((Object)this$readMethod).equals(other$readMethod)) {
            return false;
        }
        Method this$writeMethod = this.getWriteMethod();
        Method other$writeMethod = other.getWriteMethod();
        return !(this$writeMethod == null ? other$writeMethod != null : !((Object)this$writeMethod).equals(other$writeMethod));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Class<?> $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        PropertyMemberInfo $memberInfo = this.getMemberInfo();
        result = result * 59 + ($memberInfo == null ? 43 : ((Object)((Object)$memberInfo)).hashCode());
        PropertyReadWrite $readWrite = this.getReadWrite();
        result = result * 59 + ($readWrite == null ? 43 : ((Object)((Object)$readWrite)).hashCode());
        Method $readMethod = this.getReadMethod();
        result = result * 59 + ($readMethod == null ? 43 : ((Object)$readMethod).hashCode());
        Method $writeMethod = this.getWriteMethod();
        result = result * 59 + ($writeMethod == null ? 43 : ((Object)$writeMethod).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "PropertyHolder(name=" + this.getName() + ", type=" + this.getType() + ", memberInfo=" + this.getMemberInfo() + ", readWrite=" + this.getReadWrite() + ", readMethod=" + this.getReadMethod() + ", writeMethod=" + this.getWriteMethod() + ")";
    }

    @Generated
    public static class PropertyHolderBuilder {
        @Generated
        private String name;
        @Generated
        private Class<?> type;
        @Generated
        private PropertyMemberInfo memberInfo;
        @Generated
        private PropertyReadWrite readWrite;
        @Generated
        private Method readMethod;
        @Generated
        private Method writeMethod;

        @Generated
        PropertyHolderBuilder() {
        }

        @Generated
        public PropertyHolderBuilder name(@NonNull String name) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            this.name = name;
            return this;
        }

        @Generated
        public PropertyHolderBuilder type(@NonNull Class<?> type) {
            if (type == null) {
                throw new NullPointerException("type is marked non-null but is null");
            }
            this.type = type;
            return this;
        }

        @Generated
        public PropertyHolderBuilder memberInfo(@NonNull PropertyMemberInfo memberInfo) {
            if (memberInfo == null) {
                throw new NullPointerException("memberInfo is marked non-null but is null");
            }
            this.memberInfo = memberInfo;
            return this;
        }

        @Generated
        public PropertyHolderBuilder readWrite(@NonNull PropertyReadWrite readWrite) {
            if (readWrite == null) {
                throw new NullPointerException("readWrite is marked non-null but is null");
            }
            this.readWrite = readWrite;
            return this;
        }

        @Generated
        public PropertyHolderBuilder readMethod(Method readMethod) {
            this.readMethod = readMethod;
            return this;
        }

        @Generated
        public PropertyHolderBuilder writeMethod(Method writeMethod) {
            this.writeMethod = writeMethod;
            return this;
        }

        @Generated
        public PropertyHolder build() {
            return new PropertyHolder(this.name, this.type, this.memberInfo, this.readWrite, this.readMethod, this.writeMethod);
        }

        @Generated
        public String toString() {
            return "PropertyHolder.PropertyHolderBuilder(name=" + this.name + ", type=" + this.type + ", memberInfo=" + this.memberInfo + ", readWrite=" + this.readWrite + ", readMethod=" + this.readMethod + ", writeMethod=" + this.writeMethod + ")";
        }
    }
}

