/*
 * Decompiled with CFR 0.152.
 */
package io.cui.tools.reflect;

import io.cui.tools.lang.SecuritySupport;
import io.cui.tools.logging.CuiLogger;
import io.cui.tools.reflect.MoreReflection;
import io.cui.tools.string.MoreStrings;
import java.lang.reflect.Field;
import java.util.Optional;
import lombok.Generated;
import lombok.NonNull;

public class FieldWrapper {
    private static final CuiLogger log = new CuiLogger(FieldWrapper.class);
    @NonNull
    private final Field field;
    private final boolean initialAccessible;

    public FieldWrapper(Field field) {
        this.field = field;
        this.initialAccessible = field.isAccessible();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<Object> readValue(Object object) {
        log.trace("Reading from field '{}' with accessibleFlag='{}' ", this.field, this.initialAccessible);
        if (null == object) {
            log.trace("No Object given, returning Optional#empty()");
            return Optional.empty();
        }
        Field field = this.field;
        synchronized (field) {
            Optional<Object> optional;
            block12: {
                if (!this.initialAccessible) {
                    log.trace("Explicitly setting accessible flag");
                    SecuritySupport.setAccessible(this.field, true);
                }
                try {
                    optional = Optional.ofNullable(this.field.get(object));
                    if (this.initialAccessible) break block12;
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    Optional<Object> optional2;
                    block13: {
                        try {
                            log.warn(e, "Reading from field '{}' with accessible='{}' and parameter ='{}' could not complete", this.field, this.initialAccessible, object);
                            optional2 = Optional.empty();
                            if (this.initialAccessible) break block13;
                            log.trace("Resetting accessible flag");
                        }
                        catch (Throwable throwable) {
                            if (!this.initialAccessible) {
                                log.trace("Resetting accessible flag");
                                SecuritySupport.setAccessible(this.field, false);
                            }
                            throw throwable;
                        }
                        SecuritySupport.setAccessible(this.field, false);
                    }
                    return optional2;
                }
                log.trace("Resetting accessible flag");
                SecuritySupport.setAccessible(this.field, false);
            }
            return optional;
        }
    }

    public static final Optional<Object> readValue(String fieldName, Object object) {
        Optional<FieldWrapper> fieldProvider = FieldWrapper.from(object.getClass(), fieldName);
        log.trace("FieldWrapper: {}", fieldProvider);
        if (fieldProvider.isPresent()) {
            FieldWrapper fieldWrapper = fieldProvider.get();
            return fieldWrapper.readValue(object);
        }
        return Optional.empty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeValue(@NonNull Object object, Object value) {
        if (object == null) {
            throw new NullPointerException("object is marked non-null but is null");
        }
        log.trace("Writing to field '{}' with accessibleFlag='{}' ", this.field, this.initialAccessible);
        Field field = this.field;
        synchronized (field) {
            if (!this.initialAccessible) {
                log.trace("Explicitly setting accessible flag");
                SecuritySupport.setAccessible(this.field, true);
            }
            try {
                this.field.set(object, value);
            }
            catch (IllegalAccessException e) {
                String message = MoreStrings.lenientFormat("Writing to field '{}' with accessible='{}' and parameter ='{}' could not complete", this.field, this.initialAccessible, object);
                throw new IllegalStateException(message, e);
            }
            finally {
                if (!this.initialAccessible) {
                    log.trace("Resetting accessible flag");
                    SecuritySupport.setAccessible(this.field, false);
                }
            }
        }
    }

    public static final Optional<FieldWrapper> from(Class<?> type, String fieldName) {
        Optional<Field> loaded = MoreReflection.accessField(type, fieldName);
        if (loaded.isPresent()) {
            return Optional.of(new FieldWrapper(loaded.get()));
        }
        return Optional.empty();
    }

    @NonNull
    @Generated
    public Field getField() {
        return this.field;
    }
}

