/*
 * Decompiled with CFR 0.152.
 */
package io.cui.tools.string;

import io.cui.tools.collect.CollectionLiterals;
import io.cui.tools.collect.MoreCollections;
import io.cui.tools.logging.CuiLogger;
import io.cui.tools.string.JoinerConfig;
import io.cui.tools.string.MoreStrings;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;

public final class Joiner {
    private static final CuiLogger log = new CuiLogger(Joiner.class);
    @NonNull
    private final JoinerConfig joinerConfig;

    public static Joiner on(String separator) {
        Objects.requireNonNull(separator);
        return new Joiner(JoinerConfig.builder().separator(separator).build());
    }

    public static Joiner on(char separator) {
        Objects.requireNonNull(Character.valueOf(separator));
        return Joiner.on(String.valueOf(separator));
    }

    public Joiner useForNull(String nullText) {
        return new Joiner(this.joinerConfig.copy().useForNull(nullText).build());
    }

    public Joiner skipNulls() {
        return new Joiner(this.joinerConfig.copy().skipNulls(true).build());
    }

    public Joiner skipEmptyStrings() {
        return new Joiner(this.joinerConfig.copy().skipEmpty(true).build());
    }

    public Joiner skipBlankStrings() {
        return new Joiner(this.joinerConfig.copy().skipBlank(true).build());
    }

    public String join(Iterable<?> parts) {
        return this.doJoin(parts);
    }

    public String join(Iterator<?> parts) {
        return this.doJoin(CollectionLiterals.mutableList(parts));
    }

    public String join(Object ... parts) {
        return this.doJoin(CollectionLiterals.mutableList(parts));
    }

    private String doJoin(Iterable<?> parts) {
        log.trace("Joining elements with configuration {}", this.joinerConfig);
        if (MoreCollections.isEmpty(parts)) {
            return "";
        }
        ArrayList builder = new ArrayList();
        for (Object element2 : parts) {
            if (null == element2) {
                if (this.joinerConfig.isSkipNulls()) continue;
                builder.add(this.joinerConfig.getUseForNull());
                continue;
            }
            if (element2 instanceof CharSequence) {
                builder.add((CharSequence)element2);
                continue;
            }
            builder.add(MoreStrings.lenientToString(element2));
        }
        if (this.joinerConfig.isSkipEmpty()) {
            builder = builder.stream().filter(element -> !MoreStrings.isEmpty(element)).collect(Collectors.toCollection(ArrayList::new));
        }
        if (this.joinerConfig.isSkipBlank()) {
            builder = builder.stream().filter(element -> !MoreStrings.isBlank(element)).collect(Collectors.toCollection(ArrayList::new));
        }
        return String.join((CharSequence)this.joinerConfig.getSeparator(), builder);
    }

    @Generated
    Joiner(@NonNull JoinerConfig joinerConfig) {
        if (joinerConfig == null) {
            throw new NullPointerException("joinerConfig is marked non-null but is null");
        }
        this.joinerConfig = joinerConfig;
    }
}

