/*
 * Decompiled with CFR 0.152.
 */
package io.cui.tools.string;

import io.cui.tools.base.Preconditions;
import io.cui.tools.collect.CollectionBuilder;
import io.cui.tools.logging.CuiLogger;
import io.cui.tools.string.MoreStrings;
import io.cui.tools.string.SplitterConfig;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import lombok.Generated;
import lombok.NonNull;

public final class Splitter {
    private static final CuiLogger log = new CuiLogger(Splitter.class);
    @NonNull
    private final SplitterConfig splitterConfig;

    public static Splitter on(String separator) {
        MoreStrings.requireNotEmpty(separator);
        return new Splitter(SplitterConfig.builder().separator(separator).build());
    }

    public static Splitter on(char separator) {
        Objects.requireNonNull(Character.valueOf(separator));
        return new Splitter(SplitterConfig.builder().separator(String.valueOf(separator)).build());
    }

    public Splitter omitEmptyStrings() {
        return new Splitter(this.splitterConfig.copy().omitEmptyStrings(true).build());
    }

    public Splitter doNotModifySeparatorString() {
        return new Splitter(this.splitterConfig.copy().doNotModifySeparatorString(true).build());
    }

    public Splitter trimResults() {
        return new Splitter(this.splitterConfig.copy().trimResults(true).build());
    }

    public Splitter limit(int maxItems) {
        Preconditions.checkArgument(maxItems > 0, "must be greater than zero: %s");
        return new Splitter(this.splitterConfig.copy().maxItems(maxItems).build());
    }

    public List<String> splitToList(String sequence) {
        log.trace("Splitting String {} with configuration {}", sequence, this.splitterConfig);
        if (MoreStrings.isEmpty(sequence)) {
            return Collections.emptyList();
        }
        String[] splitted = sequence.split(this.handleSplitCharacter(this.splitterConfig.getSeparator()), this.splitterConfig.getMaxItems());
        if (null == splitted || 0 == splitted.length) {
            log.trace("No content to be returned for input {} and configuration {}", sequence, this.splitterConfig);
            return Collections.emptyList();
        }
        CollectionBuilder<String> builder = new CollectionBuilder<String>();
        for (String element : splitted) {
            this.addIfApplicable(builder, element);
        }
        return builder.toImmutableList();
    }

    private String handleSplitCharacter(String separator) {
        if (this.splitterConfig.isDoNotModifySeparatorString()) {
            return separator;
        }
        return Pattern.quote(separator);
    }

    private void addIfApplicable(CollectionBuilder<String> builder, String element) {
        if (null == element) {
            return;
        }
        String toDo = element;
        if (this.splitterConfig.isTrimResults()) {
            toDo = toDo.trim();
        }
        if (!this.splitterConfig.isOmitEmptyStrings()) {
            builder.add(toDo);
            return;
        }
        if (!toDo.isEmpty()) {
            builder.add(toDo);
        }
    }

    @Generated
    Splitter(@NonNull SplitterConfig splitterConfig) {
        if (splitterConfig == null) {
            throw new NullPointerException("splitterConfig is marked non-null but is null");
        }
        this.splitterConfig = splitterConfig;
    }
}

